% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicoxa.R
\name{multicoxa}
\alias{multicoxa}
\title{High dimensional multivariate cox proportional hazard data analysis}
\usage{
multicoxa(m, n, OS, event, data)
}
\arguments{
\item{m}{Starting number of column from where multivariate variables will get selected.}

\item{n}{Ending number of column till where multivariate variables will get selected.}

\item{OS}{"Column/Variable name" consisting duration of survival.}

\item{event}{"Column/Variable name" consisting survival event.}

\item{data}{High dimensional data containing survival observations and covariates.}
}
\value{
Data set containing the survival estimates and Pvalue.
}
\description{
Given the dimensions of the variables and survival informations. The function
performs multivariate Cox PH by taking 5 variables at a time.
}
\examples{
##
multicoxa(m=15,n=18,OS="os",event="death",data=hnscc)
}
