% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-PLOT.R
\docType{methods}
\name{plotDrawdowns}
\alias{plotDrawdowns}
\alias{plotDrawdowns,Strategy-method}
\title{Plot Strategy Drawdowns}
\usage{
plotDrawdowns(object, from = NULL, until = NULL, which = NULL,
  of = "portfolio", type = "relative", include.costs = TRUE,
  use.backtest = FALSE, returnValues = FALSE, ...)

\S4method{plotDrawdowns}{Strategy}(object, from = NULL, until = NULL,
  which = NULL, of = c("portfolio", "assets"), type = c("relative",
  "absolute"), include.costs = TRUE, use.backtest = FALSE,
  returnValues = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which drawdowns shall be plotted. If \code{NULL}, the start date of the performances is used.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which drawdowns shall be plotted. If \code{NULL}, the end date of the performances is used.}

\item{which}{Names or number of assets that should be included in performance. If a portfolio performance from only a subset of the assets is calculated, the weights are scaled accordingly.}

\item{of}{Performance to be extracted from assets separately or the portfolio performance.}

\item{type}{If the \code{absolute} or \code{relative} drawdown of the performance shall be returned.}

\item{include.costs}{If \code{FALSE}, the fixed and relative trading costs are NOT considered for performance calculation. Default value is \code{TRUE}. As default values for costs are \code{0}, this argument is redundant if no costs are given.}

\item{use.backtest}{If \code{TRUE}, the signals from the backtesting output are considered for drawdowns calculation. If \code{FALSE}, the signals from the normal strategy execution with the initial parameters are used.}

\item{returnValues}{If \code{TRUE}, the drawdown values are returned.}

\item{...}{Further arguments that can be passed to the underlying plot()-function.}
}
\description{
Plots drawdowns of the performance of an object of class \code{Strategy}.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Plot MA(200)-Strategy drawdowns
plotDrawdowns(myStrat.MA, from="2015-01-01", until="2015-12-31")

# Plot backtested MA(200)-Strategy drawdowns
# plotDrawdowns(myStrat.MA, from="2015-01-01", until="2015-12-31", use.backtest=TRUE)

##End(Not run)
}
