% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SICAmain.R
\name{BIC_sparseICA}
\alias{BIC_sparseICA}
\title{BIC-like Criterion for Tuning Parameter Selection in Sparse ICA}
\usage{
BIC_sparseICA(
  xData,
  n.comp,
  nu_list = seq(0.1, 4, 0.1),
  whiten = c("eigenvec", "sqrtprec", "none"),
  lngca = FALSE,
  orth.method = c("svd", "givens"),
  method = c("C", "R"),
  use_irlba = TRUE,
  eps = 1e-06,
  maxit = 500,
  verbose = FALSE,
  col.stand = TRUE,
  row.stand = FALSE,
  iter.stand = 0,
  BIC_plot = FALSE
)
}
\arguments{
\item{xData}{A numeric matrix of input data with dimensions P x T, where P is the number of features and T is the number of samples.}

\item{n.comp}{An integer specifying the number of components to estimate.}

\item{nu_list}{A numeric vector specifying the list of candidate tuning parameters. Default is \code{seq(0.1, 4, 0.1)}.}

\item{whiten}{A character string specifying the method for whitening the input \code{xData}. Options are \code{"eigenvec"}, \code{"sqrtprec"}, or \code{"none"}. Default is \code{"eigenvec"}.}

\item{lngca}{A logical value indicating whether to perform Linear Non-Gaussian Component Analysis (LNGCA). Default is \code{FALSE}.}

\item{orth.method}{A character string specifying the method for generating initial values of the U matrix. Default is \code{"svd"}.}

\item{method}{A character string specifying the computation method. If \code{"C"} (default), C code is used for Sparse ICA to improve performance. If \code{"R"}, computations are performed entirely in R.}

\item{use_irlba}{A logical value indicating whether to use the \code{irlba} method for fast truncated Singular Value Decomposition (SVD) during whitening. This can improve memory efficiency for intermediate datasets. Default is \code{TRUE}.}

\item{eps}{A numeric value specifying the convergence threshold. Default is \code{1e-6}.}

\item{maxit}{An integer specifying the maximum number of iterations for the Sparse ICA method using Laplace density. Default is 500.}

\item{verbose}{A logical value indicating whether to print convergence information during execution. Default is \code{FALSE}.}

\item{col.stand}{A logical value indicating whether to standardize columns. For each column, the mean of the entries in the column equals 0, and the variance of the entries in the column equals 1. Default is \code{TRUE}.}

\item{row.stand}{A logical value indicating whether to standardize rows. For each row, the mean of the entries in the row equals 0, and the variance of the entries in the row equals 1. Default is \code{FALSE}.}

\item{iter.stand}{An integer specifying the number of iterations for achieving both row and column standardization when \code{col.stand = TRUE} and \code{row.stand = TRUE}. Default is 5.}

\item{BIC_plot}{A logical value indicating whether to generate a plot showing the trace of BIC values for different \code{nu} candidates. Default is \code{FALSE}.}
}
\value{
A list containing the following elements:
\describe{
  \item{\code{BIC}}{A numeric vector of BIC values corresponding to each candidate \code{nu} in \code{nu_list}.}
  \item{\code{nu_list}}{A numeric vector of candidate tuning parameter values.}
  \item{\code{best_nu}}{The optimal \code{nu} selected based on the BIC-like criterion.}
}
}
\description{
This function uses a BIC-like criterion to select the optimal tuning parameter \code{nu} for Sparse ICA.
}
\examples{
\donttest{
#get simulated data
data(example_sim123)

select_sparseICA = BIC_sparseICA(xData = example_sim123$xmat, n.comp = 3, 
      method="C", BIC_plot = TRUE,verbose = TRUE, nu_list = seq(0.1,4,0.1))

(my_nu = select_sparseICA$best_nu)
}

}
