% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Biplot.R
\name{Plot_Biplot}
\alias{Plot_Biplot}
\title{Plotting Biplot}
\usage{
Plot_Biplot(X, axis = c(1,2), hide = "none",
 labels = "auto", ind.shape = 19,
 ind.color = "red", ind.size = 2,
 ind.label = FALSE, ind.label.size = 4,
 var.color = "black", var.size = 0.5,
 var.arrow.type = "open", var.arrow.angle = 30, var.arrow.length = 0.25, 
 var.label = TRUE, var.label.size = 4, var.label.angle = FALSE)
}
\arguments{
\item{X}{List containing the output of one of the functions of the package.}

\item{axis}{Vector with lenght 2 which contains the axis ploted in x and y axis.}

\item{hide}{Vector specifying the elements to be hidden on the plot. Default value is “none”. Other allowed values are “ind” and “var”.}

\item{labels}{It indicates the label for points. If it is "auto" the labels are the row names of the coordinates of individuals. If it isn't auto it would be a vector containing the labels.}

\item{ind.shape}{Points shape. It can be a number to indicate the shape of all the points or a factor to indicate different shapes.}

\item{ind.color}{Points colors. It can be a character indicating the color of all the points or a factor to use different colors.}

\item{ind.size}{Size of points.}

\item{ind.label}{Logical value, if it is TRUE it prints the name for each row of X. If it is FALSE (default) does not print the names.}

\item{ind.label.size}{Numeric value indicating the size of the labels of points.}

\item{var.color}{Character indicating the color of the arrows.}

\item{var.size}{Size of arrow.}

\item{var.arrow.type}{One of "open" or "closed" indicating whether the arrow head should be a closed triangle.}

\item{var.arrow.angle}{The angle of the arrow head in degrees (smaller numbers produce narrower, pointier arrows). Essentially describes the width of the arrow head.}

\item{var.arrow.length}{Length of the arrow head (in cm).}

\item{var.label}{Logical value, if it is TRUE (default) it prints the name for each column of X. If it is FALSE does not print the names.}

\item{var.label.size}{Numeric value indicating the size of the labels of variables.}

\item{var.label.angle}{Logical value, if it it TRUE (default) it print the vector names with orentation of the angle of the vector. If it is FALSE the angle of all tags is 0.}
}
\value{
Return a \pkg{ggplot2} object.
}
\description{
\code{Plot_Biplot} initializes a ggplot2-based visualization of the caracteristics presented in the data analized by the Biplot selected.
}
\examples{
hj.biplot <- HJBiplot(mtcars)
Plot_Biplot(hj.biplot, ind.label = TRUE)

}
\seealso{
\code{\link{HJBiplot}}, \code{\link{Ridge_HJBiplot}}, \code{\link{ElasticNet_HJBiplot}}
}
\author{
Mitzi Cubilla-Montilla, Carlos Torres-Cubilla, Ana Belen Nieto Librero and Purificacion Galindo Villardon
}
