% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_similarity.R
\name{plot_similarity}
\alias{plot_similarity}
\title{Plot ranked cosine similarity scores with top n labels}
\usage{
plot_similarity(similarity_table, top_n = 10)
}
\arguments{
\item{similarity_table}{A data frame with columns: `ID` (identifier for each item),
`cosine` (cosine similarity score), and `zscore` (z-score).}

\item{top_n}{An integer indicating the number of top IDs by zscore to label in the plot.
Default is 10.}
}
\value{
A ggplot object displaying the ranked z-scores on a log scale, with labels
        for the top n items by zscore.
}
\description{
Takes a similarity table with columns for ID, cosine, and zscore values,
and generates a plot showing the rank of the z-scores on a log scale. Labels for the top
n IDs with the highest z-scores are displayed on the plot.
}
\examples{
data(query)
skeletalvis <- load_skeletalvis(demo=TRUE)
similarity_results <- experiment_similarity(skeletalvis, query)

# Plot similarity table with labels for top 5 items
plot_similarity(similarity_results, top_n = 5)
}
