% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VRComplex.R
\name{VietorisRipsComplex}
\alias{VietorisRipsComplex}
\title{Construct a Vietoris–Rips Complex (1-skeleton + maximal simplices)}
\usage{
VietorisRipsComplex(points, epsilon)
}
\arguments{
\item{points}{A numeric matrix or data.frame with one point per row (columns are coordinates).}

\item{epsilon}{A positive numeric threshold; connect points with distance < \eqn{\epsilon}.}
}
\value{
A list with:
\describe{
  \item{network}{An \code{igraph} object representing the 1-skeleton.}
  \item{simplices}{A list of integer vectors, each the vertex indices of a maximal simplex.}
}
}
\description{
Construct a Vietoris–Rips Complex (1-skeleton + maximal simplices)
}
\details{
The Vietoris–Rips complex at scale \eqn{\epsilon} includes a simplex for every
finite set of points with pairwise distances < \eqn{\epsilon}. This function
constructs the 1-skeleton (edges only) and then uses maximal cliques in that
graph as the maximal simplices.
}
\examples{
points <- matrix(c(0, 1, 1, 0, 0, 0, 1, 1), ncol = 2)
epsilon <- 1.5
vr_complex <- VietorisRipsComplex(points, epsilon)
}
