% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewBEVAsyMixedModelCopula.R
\name{NewBEVAsyMixedModelCopula}
\alias{NewBEVAsyMixedModelCopula}
\title{Creates a bivariate asymmetric mixed model extreme value copula}
\usage{
NewBEVAsyMixedModelCopula(theta, phi)
}
\arguments{
\item{theta}{real.}

\item{phi}{real.}
}
\value{
A function that evaluates the bivariate asymmetric mixed model EV copula (with parameters \eqn{\phi} and \eqn{\theta}) at a given \eqn{2}-dimensional vector in the unit square.  The environment of the function also contains a function called \code{pdfCopula} that evaluates the probability density function of the bivariate asymmetric mixed model EV copula via automatic differentation.
}
\description{
Creates an instance of the bivariate asymmetric mixed model extreme value copula with parameters \eqn{\phi} and \eqn{\theta}.
}
\details{
The dependence function for this bivariate EV copula is \deqn{A(w) = \phi w^3 + \theta w^2 - (\phi+\theta) w + 1}
Necessary and sufficient conditions for the dependence function to be valid are
\itemize{
  \item \eqn{\theta \ge 0}
  \item \eqn{\theta + 3 \phi \ge 0}
  \item \eqn{\theta + \phi \le 1}
  \item \eqn{\theta + 2 \phi \le 1}
}
If \eqn{\phi = 0} we obtain the symmetric mixed model.
}
\seealso{
\code{\link{NewBEVMixedModelCopula}}
}
\author{
Berwin A. Turlach \email{berwin.turlach@gmail.com}
}
\keyword{distribution}
