% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs.gene.R
\name{bs.gene}
\alias{bs.gene}
\title{Generate Basis}
\usage{
bs.gene(type, k, point = 200, c = 10, or = 4, ops = "auto")
}
\arguments{
\item{type}{type indicates which type of basis is used. There are 31 types in this package}

\item{k}{k-th basis function}

\item{point}{the number of values got from k-th basis function}

\item{c}{c only used in Cspli which indicates the total number of knots to generate, the default is 10, c should not be less than k.(for splines, the true
number of basis is c-2+or)}

\item{or}{indicates the order of spline and only used in Cspli type, default is 4 which indicates cubic spline}

\item{ops}{ops indicates the function uses existing table or theoretical way to generate, the default option is "auto"}
}
\value{
A data frame which contains the value of k-th basis function
}
\description{
bs.gene() generates the value of k-th basis function. (The wavelet basis options return the full table)
}
\examples{
bs.gene("Legen", 2)
bs.gene("tri", 2, 300)
}
\references{
[3] Chen, Xiaohong. “Large Sample Sieve Estimation of Semi-Nonparametric Models.” Handbook of Econometrics, 6(B): 5549–5632,2007.
}
