% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Demography_functions.R
\name{Simulate_F_critical}
\alias{Simulate_F_critical}
\title{Estimate F critical through simulations}
\usage{
Simulate_F_critical(
  n = 1000,
  .data,
  M.estimators = NULL,
  max.F = 0.3,
  n_cores = 1
)
}
\arguments{
\item{n}{The number of simulations to be run. 1000 is recomended but smaller numbers
should be run when testing to avoid long run times.}

\item{.data}{A multi-level list of the class `Demography.inputs` produced from the
`create_data_input` function and then manually completed.}

\item{M.estimators}{Any specific natural mortality estimators to be included in the analysis.
Only one will be used in each run which is randomly selected. Must be a single estimator
or a vector of estimators. These can include: "Pet.Wro","Jensen.mat","Chen.Yuan",
"Then_hoenig","Then_pauly", "Jensen.mat","Charnov" or "Chen.Want". If none are specified
then all applicable estimators could be chosen.}

\item{max.F}{The maximum value of F for simulations}

\item{n_cores}{The number of cores to be used for parallel processing. It should be 1 core less than the
maximum number available.}
}
\value{
A list with two data.frames. The first provides the mean F critical with 95\%
    confidence intervals. The second dataframe provides the rate of increase for each
    increment of F.
}
\description{
This is a wrapper function for `Calculate_demography` which runs this function
    the specified number of times using a range of F values accross the enture age range of
    the population. This determines the rate of population increase at each increment of F.
}
\examples{
# load Silky shark data produced by create_data_input()
# Type `?create_data_input()` for details
data("Silky_data")

# Run function to get conduct an F critical analysis using
# Monte Carlo Simulations using for all available natural mortality estimators.
# Set n = at least 1000 for full analysis but use n = 10 for testing given long run times

Simulate_F_critical(n = 10, Silky_data, n_cores = 1)
}
