% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.exposure.r
\name{create.exposure}
\alias{create.exposure}
\title{Create Exposure Data Matrix}
\usage{
create.exposure(params)
}
\arguments{
\item{params}{This is a set of parameters from the initialize.data function that allows for simulation of a sequence of sequential exposures in unit time.}
}
\description{
This function create.exposure is a sub-function used in conjunction with the 
initialize.data function and creates an exposure matrix. The columns 
represent strata for the observational data and the rows represent new 
exposures in unit time. It take cumulative data and segregates it by time 
period. Do not run create.exposure as a stand-alone function.
}
\examples{
paramtest <- initialize.data(seed=8768, N=1, t0=0, tf=2, NStrata=2, 
strataRatio=c(0.2, 0.3, 0.3, 0.2), EventRate=c(0.4, 0.5), sensitivity=0.9, PPVest=0.9, RR=3.0, 
MatchRatio=1, maxSampleSize=200, maxTest=1, totalAlpha=0.05, minEvents=5, AlphaSpendType="Wald",
AlphaParameter=0.5, address=getwd(), rate=20, offset=30)
create.exposure(paramtest)
}
\keyword{sequential}
