% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife.R
\name{jackknife}
\alias{jackknife}
\alias{jackknife.SensIAT_within_group_model}
\alias{jackknife.SensIAT_fulldata_model}
\title{Perform Jackknife Resampling on an Object}
\usage{
jackknife(object, ...)

\method{jackknife}{SensIAT_within_group_model}(object, time, ...)

\method{jackknife}{SensIAT_fulldata_model}(object, time, ...)
}
\arguments{
\item{object}{An object to cross validate on.}

\item{...}{Additional arguments passed to the method.}

\item{time}{Time points for which to estimate the response.}
}
\value{
A data frame of the jackknife resampling results. For \code{SensIAT} objects,
a \code{tibble} with columns alpha, time, jackknife_mean, and jackknife_var,
where jackknife_mean is the mean of the jackknife estimates and jackknife_var
is the estimated variances of the response at the given time points for the
specified alpha values.
}
\description{
Perform Jackknife Resampling on an Object
}
\section{Methods (by class)}{
\itemize{
\item \code{jackknife(SensIAT_within_group_model)}: Perform jackknife resampling on a \code{SensIAT_within_group_model} object.

\item \code{jackknife(SensIAT_fulldata_model)}: Perform jackknife resampling on a \code{SensIAT_fulldata_model} object.

}}
\examples{
\dontrun{
object <-
fit_SensIAT_within_group_model(
    group.data = SensIAT_example_data,
    outcome_modeler = fit_SensIAT_single_index_fixed_coef_model,
    alpha = c(-0.6, -0.3, 0, 0.3, 0.6),
    id = Subject_ID,
    outcome = Outcome,
    time = Time,
    intensity.args=list(bandwidth = 30),
    knots = c(60,260,460),
    End = 830
)
jackknife.estimates <- SensIAT_jackknife(object, time = c(90, 180, 270, 360, 450))
}

}
