% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.R, R/influence_sim.R
\name{compute_influence_terms}
\alias{compute_influence_terms}
\alias{compute_influence_terms.default}
\alias{compute_influence_terms.SensIAT::Single-index-outcome-model}
\title{Compute Influence Terms}
\usage{
compute_influence_terms(outcome.model, intensity.model, alpha, data, ...)

\method{compute_influence_terms}{default}(
  outcome.model,
  intensity.model,
  alpha,
  data,
  id,
  base,
  ...
)

\method{compute_influence_terms}{`SensIAT::Single-index-outcome-model`}(
  outcome.model,
  intensity.model,
  alpha,
  data,
  base,
  tolerance = .Machine$double.eps^(1/3),
  na.action = na.fail,
  id = NULL,
  time = NULL,
  ...
)
}
\arguments{
\item{outcome.model}{The outcome model fitted to the data.}

\item{intensity.model}{The intensity model fitted to the data.}

\item{alpha}{A numeric vector representing the sensitivity parameter.}

\item{data}{A data frame containing the observations.}

\item{...}{Additional arguments passed to the method.}

\item{id}{A variable representing the patient identifier.}

\item{base}{A spline basis object.}

\item{tolerance}{Numeric value indicating the tolerance for integration, default is \code{.Machine$double.eps^(1/3)}.}

\item{na.action}{Function to handle missing values, default is \code{na.fail}.}

\item{time}{Variable indicating the time variable in the data, by Default will be extracted from the intensity model response.}
}
\description{
This function computes the influence terms for the marginal outcome model sensitivity analysis.
It is a generic function that can handle different types of outcome models.
}
\section{Methods (by class)}{
\itemize{
\item \code{compute_influence_terms(default)}: Generic method, which throws a not implemented error.

\item \code{compute_influence_terms(`SensIAT::Single-index-outcome-model`)}: Optimized method for the single index model.

}}
