% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmsen.R
\name{rmsen}
\alias{rmsen}
\title{Random number generation for the MSEN distribution}
\usage{
rmsen(n, mu = rep(0, d), Sigma, theta = Inf)
}
\arguments{
\item{n}{An integer specifying the number of data points to be simulated.}

\item{mu}{A vector of length \code{d}, where \code{d} is the dimensionality, representing the mean value.}

\item{Sigma}{A symmetric positive-definite matrix representing the scale matrix of the distribution.}

\item{theta}{A number greater than 0 indicating the tailedness parameter.}
}
\value{
A list with the following elements:
\item{X}{A data matrix with \code{n} rows and \code{d} columns.}
\item{w}{A vector of weights of dimension \code{n}.}
}
\description{
Random number generation for the MSEN distribution
}
\examples{
d <- 3
rmsen(10, mu = rep(0, d), Sigma = diag(d), theta = 0.3)
}
\references{
Punzo A., and Bagnato L. (2020). Allometric analysis using the multivariate shifted exponential normal distribution.
\emph{Biometrical Journal}, \strong{62}(6), 1525-1543.
}
