% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{rank_approx}
\alias{rank_approx}
\title{Rank-based estimation of the linear regression coefficients}
\usage{
rank_approx(y, X)
}
\arguments{
\item{y}{\code{n x 1} response vector}

\item{X}{\code{n x p} matrix of predictors (should not include an intercept!)}
}
\value{
the estimated linear coefficients
}
\description{
For a transformed Gaussian linear model, compute point estimates
of the regression coefficients. This  approach uses the ranks of the
data and does not require the transformation, but must expand the
sample size to \code{n^2} and thus can be slow.
}
\examples{
# Simulate some data:
dat = simulate_tlm(n = 200, p = 10, g_type = 'step')

# Point estimates for the linear coefficients:
theta_hat = suppressWarnings(
  rank_approx(y = dat$y,
              X = dat$X[,-1]) # remove intercept
) # warnings occur from glm.fit (fitted probabilities 0 or 1)

# Check: correlation with true coefficients
cor(dat$beta_true[-1], # excluding the intercept
    theta_hat)

}
