% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ssp.R
\name{plot_ssp}
\alias{plot_ssp}
\title{SSP Plot: Visualization of MultSE and Sampling Effort}
\usage{
plot_ssp(xx, opt, multi.site)
}
\arguments{
\item{xx}{A data frame generated by \code{\link{summary_ssp}}.}

\item{opt}{A vector or data matrix generated by \code{\link{ioptimum}}.}

\item{multi.site}{Logical. Indicates whether several sites were simulated.}
}
\value{
A \code{\link[ggplot2:ggplot2-package]{ggplot2}} object.
}
\description{
Plots the relationship between MultSE and sampling effort using results from SSP simulations.
}
\details{
This function visualizes the behavior of MultSE (pseudo-multivariate standard error)
as sampling effort increases. If simulations involve two sampling scales (e.g., sites and samples),
separate graphs are generated. Two shaded bands highlight sub-optimal (light grey)
and optimal (dark grey) improvements in precision. The graph also displays the relative gain in precision
(as cumulative percentage) for each level of sampling effort, compared to the lowest.

This visualization helps identify when additional sampling effort results in diminishing returns.
The plot is generated using \code{\link[ggplot2:ggplot2-package]{ggplot2}} and can be further customized.
}
\note{
This is an exploratory plot and can be edited or extended using standard \code{ggplot2} functions.
}
\examples{
## Single site: micromollusk from Cayo Nuevo (Yucatan, Mexico)
data(micromollusk)
par.mic <- assempar(data = micromollusk, type = "P/A", Sest.method = "average")
sim.mic <- simdata(par.mic, cases = 2, N = 20, sites = 1)
sam.mic <- sampsd(dat.sim = sim.mic, Par = par.mic, transformation = "P/A",
                  method = "jaccard", n = 10, m = 1, k = 3)
summ.mic <- summary_ssp(results = sam.mic, multi.site = FALSE)
opt.mic <- ioptimum(xx = summ.mic, multi.site = FALSE)
plot_ssp(xx = summ.mic, opt = opt.mic, multi.site = FALSE)

## See the full multi-site workflow in the vignette

}
\references{
Guerra-Castro, E.J., Cajas, J.C., Simões, N., Cruz-Motta, J.J., & Mascaró, M. (2021). SSP: an R package to estimate sampling effort in studies of ecological communities. Ecography 44(4), 561-573. doi:  \doi{10.1111/ecog.05284}

Wickham, H. (2016). ggplot2: Elegant Graphics for Data Analysis. Springer.
}
\seealso{
\code{\link[ggplot2:ggplot2-package]{ggplot2}}
}
