% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSEParser.R
\name{SSEparser}
\alias{SSEparser}
\title{Parse a Server Sent Event}
\value{
An object with R6 class \code{SSEparser}
}
\description{
This class can help you parse a single server sent event or a stream of them.
You can inherit the class for a custom application.
The \code{\link[=parse_sse]{parse_sse()}} function wraps this class for a more \emph{functional} approach.
}
\details{
The \href{https://html.spec.whatwg.org/multipage/server-sent-events.html#server-sent-events}{HTML specification}
tells us that event streams are composed by chunks (also called \emph{blocks}, or \emph{messages}) and lines.
A single new line character (\verb{\\n}) states the end of a line, and two consecutive new line characters (\verb{\\n\\n}) state the end of a chunk.

This means that, in practice, an event can be composed of one or more chunks, and a chunk can be composed of one or more lines.

\if{html}{\out{<div class="sourceCode">}}\preformatted{data: This is the first chunk, it has one line

data: This is the second chunk
extra: It has two lines

data: This is the third chunk, it has an id field. This is common.
id: 123

: Lines that start with a colon are comments, they will be ignored
data: This is the forth chunk, it has a comment

data: This is the fifth chunk. Normally you will receive a data field
custom: But the server can send custom field names. SSEparser parses them too.

}\if{html}{\out{</div>}}

Typically, an event stream will send a single chunk for event, but it is important
to understand that event != chunk because \code{SSEparser$events} will be a list of
all the chunks received as it makes a more consistent output.
}
\examples{
example_event <- 
"data: This is the first chunk, it has one line

data: This is the second chunk
extra: It has two lines

data: This is the third chunk, it has an id field. This is common.
id: 123

: Lines that start with a colon are comments, they will be ignored
data: This is the fourth chunk, it has a comment

data: This is the fifth chunk. Normally you will receive a data field
custom: But the server can send custom field names. SSEparser parses them too."
 
parser <- SSEparser$new()
parser$parse_sse(example_event)
 
str(parser$events)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{events}}{List  that contains all the events parsed. When the class is initialized, is just an empty list.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SSEparser-append_parsed_sse}{\code{SSEparser$append_parsed_sse()}}
\item \href{#method-SSEparser-parse_sse}{\code{SSEparser$parse_sse()}}
\item \href{#method-SSEparser-new}{\code{SSEparser$new()}}
\item \href{#method-SSEparser-clone}{\code{SSEparser$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SSEparser-append_parsed_sse"></a>}}
\if{latex}{\out{\hypertarget{method-SSEparser-append_parsed_sse}{}}}
\subsection{Method \code{append_parsed_sse()}}{
Takes a parsed event and appends it to the \code{events} field. You can overwrite this method if you decide to extend this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSEparser$append_parsed_sse(parsed_event)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parsed_event}}{Event to append to the \code{events} field.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SSEparser-parse_sse"></a>}}
\if{latex}{\out{\hypertarget{method-SSEparser-parse_sse}{}}}
\subsection{Method \code{parse_sse()}}{
Takes a string that comes from a server sent event and parses it to an R list. You should never overwrite this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSEparser$parse_sse(event)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{A length 1 string containing a server sent event as specified in the \href{https://html.spec.whatwg.org/multipage/server-sent-events.html#server-sent-events}{HTML spec}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SSEparser-new"></a>}}
\if{latex}{\out{\hypertarget{method-SSEparser-new}{}}}
\subsection{Method \code{new()}}{
Create a new SSE parser
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSEparser$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SSEparser-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SSEparser-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SSEparser$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
