% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPRT.R
\name{sprt}
\alias{sprt}
\title{Sequential Probability Ratio Test (SPRT)}
\usage{
sprt(
  x,
  alpha = 0.05,
  beta = 0.05,
  p0,
  p1,
  dist = c("bernoulli", "poisson", "normal"),
  sigma = 1
)
}
\arguments{
\item{x}{Vector of observed values.}

\item{alpha}{Type I error rate.}

\item{beta}{Type II error rate.}

\item{p0}{Null hypothesis parameter (probability or mean).}

\item{p1}{Alternative hypothesis parameter (probability or mean).}

\item{dist}{Distribution: "bernoulli", "normal", or "poisson".}

\item{sigma}{Standard deviation (for normal distribution only).}
}
\value{
A list with elements:
\item{decision}{"Accept H0", "Reject H0", or "Continue sampling"}
\item{n_decision}{Step at which decision was made (NA if continue)}
\item{logL}{Cumulative log-likelihood ratios for each step}
\item{A}{Upper threshold (log scale)}
\item{B}{Lower threshold (log scale)}
}
\description{
Performs the SPRT for Bernoulli, Normal, or Poisson data.
}
\examples{
x <- c(0,0,1,0,1,1,1,0,0,1,0,0)
res <- sprt(x, alpha = 0.05, beta = 0.1, p0 = 0.1, p1 = 0.3)
print(res)
x1 <- c(52, 55, 58, 63, 66, 70, 74)
result1 <-sprt(x1, alpha = 0.05, beta = 0.1, p0 = 50, p1 = 65, dist = "normal", sigma = 10)
result1
}
