% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.SLRMss.R
\name{print.SLRMss}
\alias{print.SLRMss}
\title{Print values of a SLRMss object}
\usage{
\method{print}{SLRMss}(x, ...)
}
\arguments{
\item{x}{An object of class \code{SLRMss}.}

\item{...}{Currently ignored.}
}
\value{
Coefficients, AICc and BIC extracted from a SLRMss object.
}
\description{
This function displays a succinct summary of the fitted model. It includes the mean and dispersion parameter estimates, corrected Akaike information criterion and Bayesian information criterion.
}
\examples{
data(orange)
fit <- SLRMss(emulsion ~ arabicgum + xanthangum + orangeoil, family="Student", xi=3,
testingbeta="xanthangum", statistic="LR", data=orange)
print(fit)
}
