% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hab_api_functions.R
\name{get_toxin_list}
\alias{get_toxin_list}
\title{Retrieve marine biotoxin data from IOC-UNESCO Toxins Database}
\usage{
get_toxin_list(return_count = FALSE)
}
\arguments{
\item{return_count}{Logical. If \code{TRUE}, the function returns the count of toxins available in the database. If \code{FALSE} (default), it returns detailed toxin data.}
}
\value{
If \code{return_count = TRUE}, the function returns a numeric value representing the number of toxins in the database. Otherwise, it returns a \code{tibble} of toxins with detailed information.
}
\description{
This function collects data from the \href{https://toxins.hais.ioc-unesco.org/}{IOC-UNESCO Toxins Database} and returns information about toxins.
}
\examples{
\donttest{
# Retrieve the full list of toxins
toxin_list <- get_toxin_list()
head(toxin_list)

# Retrieve only the count of toxins
toxin_count <- get_toxin_list(return_count = TRUE)
print(toxin_count)
}

}
\seealso{
\url{https://toxins.hais.ioc-unesco.org/} for IOC-UNESCO Toxins Database.
}
