#' sample70 data
#'
#' 
#' All possible simple random samples that can be generated from the population in Example 2.2 of SDA.
#'
#'
#' @format This data frame contains the following columns:
#' \describe{
#' \item{sampnum:}{sample number}
#' 
#' \item{u1:}{sampled units in \eqn{\cal{S}}}
#' 
#' \item{u2:}{sampled units in \eqn{\cal{S}}}
#' 
#' \item{u3:}{sampled units in \eqn{\cal{S}}}
#' 
#' \item{u4:}{sampled units in \eqn{\cal{S}}}
#' 
#' \item{y1:}{values of \eqn{y_1} in sample \eqn{\cal{S}}}
#' 
#' \item{y2:}{values of \eqn{y_2} in sample \eqn{\cal{S}}}
#' 
#' \item{y3:}{values of \eqn{y_3} in sample \eqn{\cal{S}}}
#' 
#' \item{y4:}{values of \eqn{y_4} in sample \eqn{\cal{S}}}
#' 
#' \item{total:}{estimated population total}
#' }
#'  
#'  
#'  
#'
#' @docType data
#'
#' @usage data(sample70)
#'
#'
#'
#' @keywords datasets
#'
#' @references Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.
#' 
#'@references Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press.
#' 
#' 
#'
#' 
#' 
#' 
"sample70"

