#' divorce data
#'
#' 
#' Data from a sample of divorce records for states in the Divorce Registration
#' Area.
#'
#'
#' @format This data frame contains the following columns:
#' 
#' \describe{
#'\item{state:}{state name (character variable)}
#'
#'\item{abbrev:}{state abbreviation (character variable)}
#'
#'\item{samprate:}{sampling rate for state}
#'
#'\item{numrecs:}{number of records sampled in state}
#'
#'\item{hsblt20:}{number of records in sample with husband's age < 20}
#'
#'\item{hsb20to24:}{number of records with 20 <= husband's age <= 24}
#'
#'\item{hsb25to29:}{number of records with 25 <= husband's age <= 29}
#'
#'\item{hsb30to34:}{number of records with 30 <= husband's age <= 34}
#'
#'\item{hsb35to39:}{number of records with 35 <= husband's age <= 39}
#'
#'\item{hsb40to44:}{number of records with 40 <= husband's age <= 44}
#'  
#'  \item{hsb45to49:}{number of records with 45 <= husband's age <= 49}
#'  
#'  \item{hsbge50:}{number of records with husband's age => 50}
#'  
#'  \item{wflt20:}{number of records with wife's age < 20}
#'  
#'  \item{wf20to24:}{number of records with 20 <= wife's age <= 24}
#'  
#'  \item{wf25to29:}{number of records with 25 <= wife's age <= 29}
#'  
#'  \item{wf30to34:}{number of records with 30 <= wife's age <= 34}
#'  
#'  \item{wf35to39:}{number of records with 35 <= wife's age <= 39}
#'  
#'  \item{wf40to44:}{number of records with 40 <= wife's age <= 44}
#'  
#'  \item{wf45to49:}{number of records with 45 <= wife's age <= 49}
#'  
#'  \item{wfge50:}{number of records with wife's age => 50}
#'  
#'}
#' @docType data
#'
#' @usage data(divorce)
#'
#'
#'
#' @keywords datasets
#' 
#' @references Source: National Center for Health Statistics (1987).
#'
#' @references Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.
#' 
#'@references Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press. 
#' 
#'
#' 
#' 
#' 
"divorce"

