% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WW.R
\name{WW}
\alias{WW}
\title{The Wagner-Whitin algorithm}
\usage{
WW(x, a, h, method = c("backward", "forward"))
}
\arguments{
\item{x}{A numeric vector containing the demand per unit time}

\item{a}{A numeric number for the set-up cost per unit and period}

\item{h}{A numeric number for the holding cost per unit and period}

\item{method}{Character string specifing which algorithm to use: "backward" (default) or "forward"}
}
\description{
\code{WW} implements the Wagner-Whitin algorithm. Considering time-varying demand, the algorithm builds production
plans that minimizes the total setup and holding costs in a finite horizon of time, assuming zero starting inventory
and no backlogging
}
\examples{
 \dontrun{
# Example from Hiller, p.952, reproduced bellow:
# An airplane manufacturer specializes in producing small airplanes. It has just received
# an order from a major corporation for 10 customized executive jet airplanes for the use of
# the corporation's upper management. The order calls for three of the airplanes to be delivered
# (and paid for) during the upcoming winter months (period 1), two more to be delivered during
# the spring (period 2), three more during the summer (period 3), and the final two during the fall
# (period 4). Setting up the production facilities to meet the corporation's specifications for
# these airplanes requires a setup cost of $2 million.
# The manufacturer has the capacity to produce all 10 airplanes within a couple of months, when the
# winter season will be under way. However, this would necessitate holding seven of the airplanes in
# inventory, at a cost of $200,000 per airplane per period, until their scheduled delivery times
# (...) Management would like to determine theleast costly production schedule for filling
# this order.}


x  <- c(3,2,3,2)
a  <- 2
h  <- 0.2
WW(x,a,h,method="backward")

 \dontrun{
# The total variable cost is $4.8 million (minimum value in the first raw). Since we have two
# minimun values in the first raw (positions 2 and 4), we have the following solutions:
# Solution 1:  Produce to cover demand until period 2, 5 airplanes. In period 3, new decision,
# minimun value 2.4 in period 4 (third raw). Then in period 3 produce to cover demand until 
# period 4, 5 airplanes.
# Solution 2: Produce to cover demand until period 4, 10 airplanes.}
 
WW(x,a,h,method="forward")

 \dontrun{
#The total variable cost is $4.8 million (minimum value in the last raw). Since we have two minimun
# values in columns 1 and 3, the solutions are:
# Solution 1: Produce in period 1 to cover demand until period 4, 10 airplanes.
# Solution 2: Produce in period 3 to cover demand until period 4, 5 airplanes.In period 2, new
# decision, minimun value 2.4 in raw 3. Then in period 1 produce to cover demand until
# period 2, 5 airplanes.}

}
\seealso{
EOQ, EPQ, newsboy
}
