% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCB_dense.R
\name{SCB_dense}
\alias{SCB_dense}
\title{Construct Simultaneous Confidence Bands (SCB) for Dense Functional Data}
\usage{
SCB_dense(
  A,
  mean_A = NULL,
  alpha = 0.05,
  Mboots = NULL,
  method = "t",
  weights = "rademacher",
  SCB = TRUE
)
}
\arguments{
\item{A}{A data array of dimension \eqn{(D_1, D_2, \ldots, D_N)}, where N is the number of repetition/subjects. There should be no NA in A.}

\item{mean_A}{Optional array of same shape as \code{A[,,1]}, representing the estimated mean of the data.}

\item{alpha}{Significance level for SCB. Default is 0.05.}

\item{Mboots}{Number of bootstrap replications. Default is 5000.}

\item{method}{Method for SD estimation: "t" or "regular". Default is "t".}

\item{weights}{Multiplier type: "rademacher", "gaussian", or "mammen". Default is "rademacher"."}

\item{SCB}{Logical value for whether to calculate the SCB or not. Default is TRUE.}
}
\value{
If \code{SCB = TRUE}, returns a list containing:
\item{mu_hat}{Estimated mean function for the group of interest.}
\item{se_hat}{Standard errors of the estimated means.}
\item{scb_low}{Lower bound of the simultaneous confidence band.}
\item{scb_up}{Upper bound of the simultaneous confidence band.}
\item{type}{A character description of the output type.}

If \code{SCB = FALSE}, returns:
\item{thres}{The alpha quantile estimated by Multiplier Bootstrap}
}
\description{
Construct Simultaneous Confidence Bands (SCB) for Dense Functional Data
}
\keyword{#}
\keyword{SCB_functional_outcome}
\keyword{Used}
\keyword{by}
\keyword{internal}
\keyword{internally}
