% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.image.R
\name{read.image}
\alias{read.image}
\title{Read a Binary Image}
\usage{
read.image(file, invert = FALSE)
}
\arguments{
\item{file}{a character string that specifies the image to read.}

\item{invert}{a logical value that indicates if the B/W colors should be inverted.}
}
\value{
An integer matrix that represents the preprocessed image.
}
\description{
This function reads a reconstructed binary image, possibly, produced from an
X-Ray, CT scan, MRI, etc. and processed by standard image processing
algorithms. The image is then preprocessed to facilitate the procedure in
the \code{\link{binary.segmentation}} function.
}
\details{
The binary image is preprocessed as follows:
\itemize{
\item Check if image contains multiple color channels, non-binary, or empty.
\item Invert black and white colors (optional).
\item Ensure image is truly binary by converting all values greater than zero to \code{1}.
\item Expand the border around the image with \code{0}s.
\item Rotating the image, if it is not stored as an \code{RData} file.
}
}
\seealso{
\code{\link{binary.segmentation}} for more information on reconstructed binary images.
}
