# ******************************************************************************
#
# R package SAFARI by Esteban Fernández and Qiwei Li
# Copyright (C) 2021
#
# This file is part of the R package SAFARI.
#
# The R package SAFARI is free software: You can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or any later
# version (at your option). See the GNU General Public License at
# <https://www.gnu.org/licenses/> for details.
#
# The R package SAFARI is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# ******************************************************************************

#' Shape Analysis for AI-Reconstructed Images
#'
#' The R package \pkg{SAFARI} provides functions for image processing and
#' shape analysis of regions of interest (ROI) in AI-reconstructed images.
#'
#' The main functions are summarized as follows:
#' \itemize{
#'     \item \code{read.image}: loads and preprocesses reconstructed binary images for segmentation;
#'     \item \code{binary.segmentation}: ROI segmentation and optional feature extraction;
#'     \item \code{compute.features}: feature extraction for an individual ROI;
#'     \item \code{rc.plot}: visualize reconstructed binary or segmented images.
#' }
#'
#' See the package vignettes for more introduction and demonstration.
#'
#' @docType package
#' @name SAFARI-package
#'
NULL
