% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blogs.R
\name{get_blog_likes}
\alias{get_blog_likes}
\title{Retrieve Blog's Likes}
\usage{
get_blog_likes(
  blog,
  limit = 20,
  offset = 0,
  after,
  before,
  api_key = NULL,
  ...
)
}
\arguments{
\item{blog}{name of the blog}

\item{limit}{The number of results to return: 1–50}

\item{offset}{post index to start at}

\item{after}{integer. Retrieve posts liked after the specified timestamp}

\item{before}{integer. Retrieve posts liked before the specified timestamp}

\item{api_key}{app consumer key. If NULL, attempts to load from the environment variable RTUMBLR_TOKEN}

\item{...}{further parameters as described here: \url{https://www.tumblr.com/docs/en/api/v2}}
}
\value{
tibble of liked posts
}
\description{
This method can be used to retrieve the publicly exposed likes from a blog. \strong{Seems to work only for your own blog}
}
\details{
You can only provide either before, after, or offset.
If you provide more than one of these options together you will get an error.
You can still use limit with any of those three options to limit your result set.
When using the offset parameter the maximum limit on the offset is 1000. If you would like to get more results than that use either before or after.
}
\examples{
\dontrun{
# replace "your-blog-name" with your Tumblr username
get_blog_likes(blog = "your-blog-name")
}
}
