% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaTransformSeriesToStationaryTrendOnly_ciPercentile}
\alias{tsEvaTransformSeriesToStationaryTrendOnly_ciPercentile}
\title{tsEvaTransformSeriesToStationaryTrendOnly_ciPercentile}
\usage{
tsEvaTransformSeriesToStationaryTrendOnly_ciPercentile(
  timeStamps,
  series,
  timeWindow,
  percentile
)
}
\arguments{
\item{timeStamps}{A vector of time stamps for the time series.}

\item{series}{The original time series.}

\item{timeWindow}{The size of the moving window used for detrending.}

\item{percentile}{The percentile value used to compute the extreme trend
of the stationary series.}
}
\value{
A list containing the following elements:
\describe{
\item{\code{runningStatsMulteplicity}}{The running statistics multiplicity}
\item{\code{stationarySeries}}{The transformed stationary trend only series}
\item{\code{trendSeries}}{The trend series}
\item{\code{trendSeriesNonSeasonal}}{The non-seasonal trend series}
\item{\code{trendError}}{The error on the trend}
\item{\code{stdDevSeries}}{The standard deviation series}
\item{\code{stdDevSeriesNonSeasonal}}{The non-seasonal standard deviation series}
\item{\code{stdDevError}}{The error on the standard deviation}
\item{\code{timeStamps}}{The time stamps}
\item{\code{nonStatSeries}}{The original non-stationary series}
\item{\code{statSer3Mom}}{The running mean of the third moment of the stationary series}
\item{\code{statSer4Mom}}{The running mean of the fourth moment of the stationary series}
}
}
\description{
\code{tsEvaTransformSeriesToStationaryTrendOnly_ciPercentile} transforms a
time series to a stationary ones using a moving average as the trend and
a running percentiles to represent the slowly varying amplitude of the distribution
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series <- ArdecheStMartin[,2]
#select only the 5 latest years
yrs <- as.integer(format(timeStamps, "\%Y"))
tokeep <- which(yrs>=2015)
timeStamps <- timeStamps[tokeep]
series <- series[tokeep]
timeWindow <- 365 # 1 year
percentile <- 90
result <- tsEvaTransformSeriesToStationaryTrendOnly_ciPercentile(timeStamps,
series, timeWindow, percentile)
plot(result$trendSeries)
}
