% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainTSEVA.R
\name{TsEvaNs}
\alias{TsEvaNs}
\title{TsEvaNs Function}
\usage{
TsEvaNs(
  timeAndSeries,
  timeWindow,
  transfType = "trendPeaks",
  minPeakDistanceInDays = 10,
  seasonalityVar = NA,
  minEventsPerYear = -1,
  gevMaxima = "annual",
  ciPercentile = 90,
  gevType = "GEV",
  evdType = c("GEV", "GPD"),
  tail = "high",
  epy = -1,
  lowdt = 7,
  trans = NULL,
  TrendTh = NA
)
}
\arguments{
\item{timeAndSeries}{A data frame containing the timestamp and
corresponding series data.}

\item{timeWindow}{The time window for analysis.}

\item{transfType}{The transformation type for non-stationary EVA.
It can be one of the following:
\describe{
\item{\code{trend}}{Long-term variations of the timeseries}
\item{\code{seasonal}}{Long-term and seasonal variations of extremes}
\item{\code{trendCIPercentile}}{Long-term variations of extremes using
a specified percentile}
\item{\code{trendPeaks}}{Long-term variations of the peaks}
}}

\item{minPeakDistanceInDays}{The minimum peak distance in days.}

\item{seasonalityVar}{A logical value indicating whether to consider
seasonality in the analysis.}

\item{minEventsPerYear}{The minimum number of events per year.}

\item{gevMaxima}{The type of maxima for the GEV distribution
(annual or monthly, default is annual).}

\item{ciPercentile}{The percentile value for confidence intervals.}

\item{gevType}{The type of GEV distribution (GEV or GPD).}

\item{evdType}{The type of extreme value distribution (GEV or GPD).}

\item{tail}{The mode of the analysis
(e.g., high for flood peaks or low for drought peaks).}

\item{epy}{The average number of events per year, can be specified by the
user or automatically set according to the tail selected.}

\item{lowdt}{The temporal resolultion used for low values. default is 7 days.}

\item{trans}{The transformation used to fit the EVD. Can be:
\describe{
\item{\code{ori}}{use of original data}
\item{\code{rev}}{Reversing the data (used for low extremes)}
\item{\code{inv}}{inversing the data (used for low extreme, can lead to unstabilities)}
\item{\code{lninv}}{log of inverse the data (used for low extreme, under development)}
}}

\item{TrendTh}{The threshold used to compute the trend on extreme events
(only valid if transftype==trendPeaks). If not specified, the optimal
threshold is identified within the function}
}
\value{
A list containing the results of the non-stationary EVA.
Containing the following components:
\describe{
\item{\code{nonStationaryEvaParams}}{The estimated parameters
for non-stationary EVA.
Parameters include GEV and GPD parameters for each timestep,
confidence intervals, and other statistical measures}
\item{\code{stationaryTransformData}}{The transformed data for stationary EVA.
Includes the stationary series, trend, and standard deviation series}
}
}
\description{
This function performs non-stationary extreme value analysis (EVA) on a
time series data.
}
\details{
The function takes a time series data and performs non-stationary
EVA using various transformation types and parameters depending
on the input data provided.
Results are returned as a list containing the non-stationary EVA parameters
and the transformed data for stationary EVA
and can be used as input for further analysis.
In particular for the following function
}
\examples{
# Example usage of TsEvaNs function
timeAndSeries <- ArdecheStMartin
#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
#keep only the 30 last years
yrs <- as.integer(format(timeAndSeries$date, "\%Y"))
tokeep <- which(yrs>=1990)
timeAndSeries <- timeAndSeries[tokeep,]
timeWindow <- 10*365 # 10 years
result <- TsEvaNs(timeAndSeries, timeWindow,
transfType = 'trendPeaks',tail = 'high')

}
\references{
Mentaschi, L., Vousdoukas, M., Voukouvalas, E., Sartini, L., Feyen, L.,
Besio, G., and Alfieri, L. (2016). The transformed-stationary approach:
a generic and simplified methodology for non-stationary extreme value analysis.
\emph{Hydrology and Earth System Sciences}, \strong{20}(9), 3527-3547.
doi:10.5194/hess-20-3527-2016.
}
