% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variable.R
\name{plot_variable}
\alias{plot_variable}
\title{Plot path metrics.}
\usage{
plot_variable(
  variable,
  experiment,
  factor = NA,
  factor.colours = "auto",
  x.axis = NA,
  type = NA,
  dist = "q",
  transparency = 0.25,
  exclude.probe = FALSE,
  boundaries = NA,
  boundary.lwd = 1,
  legend = TRUE,
  axis.titles = TRUE,
  margins = c(5, 4, 4, 8),
  ...
)
}
\arguments{
\item{variable}{The variable/metric that should be plotted. See Details for
the ways to specify this.}

\item{experiment}{The \code{rtrack_experiment} object as returned from
\code{\link{read_experiment}}.}

\item{factor}{The factor (from the table in \code{experiment$factors}) by
which the data should be grouped. Each factor level will be plotted as a
separate series. If not specified, all values are plotted together in one
series.}

\item{factor.colours}{A colour to be used for each factor level. If not
specified, colours will be automatically generated. The vector of colours
is returned to allow additional plot customisation.}

\item{x.axis}{The scale of the x axis. "Day" will add a labelled axis with
tick marks at each day. If this parameter is set to "Trial", then tick
marks are added for each trial. If set to "none", then no x axis will be
drawn. Default (\code{NA}) selects an option appropriate for the experiment
type.}

\item{type}{The type of plot to draw. Either "p" for a side-by-side
stripchart with individual points, "l" for a line graph connecting
medians/means and whiskers/error bars for data spread (upper and lower
quartiles or standard deviation, depending on the value of \code{dist}), or
"b" for both of these overlaid. Additional options "L" and "B" are like
their lower-case counterparts but a point is also added at the median/mean.
This is valuable especially when there is only one trial between
boundaries. The default is \code{NA} indicating that the function should
choose the most appropriate type for the plot.}

\item{dist}{The type of distribution. Either "quartiles" or "non-parametric"
(default) to show the median +/- upper and lower quartiles, or "sd" or
"parametric" to show mean +/- standard deviation. This parameter can be
abbreviated. The parametric option should only be used if the data come
from a normal/Gaussian distribution. Although not a measure of the
distribution, it is also possible to use this parameter to show the mean
+/- the standard error of the mean (SEM) using the option "sem".}

\item{transparency}{A value from 0 (fully transparent) to 1 (fully opaque)
governing the transparency of the points. If filled symbols are used, then
transparency can help distinguish overlapping points.}

\item{exclude.probe}{Should data from probe trials be excluded (see Details).}

\item{boundaries}{Where should the boundaries between arena types be drawn
(see Details).}

\item{boundary.lwd}{The thickness of the boundaries. Default is 1.}

\item{legend}{Should a legend be added. Default is \code{TRUE}.}

\item{axis.titles}{Should axis titles be drawn. Default is to add titles for
the x and y axes. These can be suppressed and added afterwards (using
\code{\link[graphics]{title}}). This might be helpful for localising to a
different language for example.}

\item{margins}{The margins of the plot (see the option \code{mar} in
\code{\link[graphics]{par}}). The defaults should usually be fine, but they
can be overridden if, for example, factor names are very long.}

\item{...}{Additional arguments to \code{plot}.}
}
\value{
A named vector of colours used for each factor level.
}
\description{
Plots the metrics that have been calculated from path coordinates.
}
\details{
Many of the summary metrics (as returned in the \code{summary} component of
the \code{\link{calculate_metrics}} output are useful for analysis in their
own right. These can be plotted as mean values over each trial with standard
error bars. If a factor is provided, then one data series will be plotted for
each level of the factor. To view data for mutliple factors, they will need
to be collapsed into one composite factor for plotting using this function.
If probe trials were used, then "latency to goal" and several other variables
do not make much sense, so the data for the probe trials can be suppressed.
For this to work, a column named "Probe" must be present in the experiment
description spreadsheet and must contain the value "TRUE" for each probe
trial.

The \code{variable} parameter can either be specified as the name of one of
the summary metrics, the name of one of the columns from the experiment
description, or as a numeric vector. In the latter case, the numeric vector
must be the same length as the number of tracks in the experiment.


Boundaries are drawn (as broken vertical lines) between different arena types
(for example between acquisition and goal reversal phases of a Morris water
maze experiment). By default, these are added between each unique arena
definition. If this is not appropriate, then this can be overridden by
providing the \code{boundaries} parameter with a \code{\link{matrix}} or
\code{\link{data.frame}} with two columns for the day and trial number
respectively. Multiple boundaries can be defined by entering the day and
trial index into rows of this table. Use \code{boundaries = NULL} to suppress
boundary lines altogether.
}
\examples{
# This function relies on data too large to include in the package.
# For a worked example, please see the vignette "Rtrack MWM analysis"
# in the online package documentation at
# https://rupertoverall.net/Rtrack/.

}
