% This was not Generated by roxygen2 (4.1.1): edit by hand. Changes in tauchen.R not reflected here. 
\name{Tgrid}
\alias{Tgrid}
\title{Tgrid}
\usage{
Tgrid(ne, ssigma_eps, llambda_eps, m)
}
\arguments{
\item{ne}{Number of points of the grid of the finite-state Markov chain that mimics the AR(1) process}

\item{ssigma_eps}{Standard deviation of exogenous shock in the AR(1) process}

\item{llambda_eps}{Persistence parameter of the AR(1) process}

\item{m}{Tauchen parameter for the width of the process (number of standard deviations of the AR(1) process covered by the grid)}
}
\value{
An array with the grid points of a finite-state Markov chain which approximates the original AR(1) process.
}
\description{
This function generates a grid of a finite-state Markov chain that mimics an AR(1) process with persistence parameter llamda, standard deviation ssigma and a fixed parameter m.
}
\details{
See Tauchen (1986) for details.
}
\examples{
results = Tgrid(5, 0.02, 0.98, 3)
}




