PFoutput <-
function(PF, stas=NULL, sol=NULL, format=0, destdir=NULL  )
  {
###  save pickfile information to disk in a variety of formats

      
      if(is.null(destdir) ) {
          destdir= tempdir()
          message(paste('Writing output to temp dir ', destdir) )
          
      }

    if(missing(format)) format = 0
    ###   format = 0,1,2,3,4
    ###   format <= 0 means save in all formats

    #### sol = solution to earthquake location problem (lat,lon, z, t0)
    ###   stas = station location list

      if(is.null(stas) ){
          
          stas = PF$STAS
      }

    if(any( 0 %in% format )  )
    {
        WW = RSEIS::uwpfile2ypx(PF)

        twpx  = latlonz2wpx(WW, PF$STAS )

       #  twpx = PF
        twpx$phase[WW$phase=="Y"] = "P"
        LOC = PF$LOC
     ###   message(paste(collapse=' ', LOC$lat )  )
       ###      message(paste(collapse=' ', LOC$lon )  )
        ###      message(paste(collapse=' ', LOC$sec )  )
        
        PF =  INITpickfile(stas=stas, src=LOC, WPX=twpx)

        ###    message('POST' )
        ###    message(paste(collapse=' ', PF$LOC$lat )  )

      }

    
    if(!is.null(sol))
    {
        
        upf = UPdateEQLOC(PF,  sol, stas=stas)
      }
    else
      {
        upf = PF

      }

      

      dout = c(upf$LOC$yr, upf$LOC$jd, upf$LOC$hr, upf$LOC$mi,  upf$LOC$sec)
      fout1 = PCfiledatetime(dout, 0)
      foutp = paste(fout1,"uwpf", sep="." )
      upf$filename =   foutp
      output=upf$filename
    
      foutcvs = paste(fout1,"wpx", sep="." )
      fout2 = paste(fout1,"RDATA", sep="." )
      
      if(any( c(1,0) %in% format ) ) {
           WW = RSEIS::uwpfile2ypx(PF)
        
        twpx  = latlonz2wpx(WW, PF$STAS )
        
          fout3 = paste(destdir, fout2, sep="/")
          save(file=fout3, twpx)
       ####   message(fout3)
          }

      if(any( c(2,0) %in% format ) ) {
          upf3 = paste(destdir, foutp, sep="/")
          
          RSEIS::writeUWpickfile(upf, output=upf3)
       ####    message(upf3)
          }
    if(any( c(3,0) %in% format ) )
    {
        WW = RSEIS::uwpfile2ypx(PF)
        
        twpx  = latlonz2wpx(WW, PF$STAS )
        
        foutcvs3 = paste(destdir, foutcvs, sep="/")
        write.csv( twpx , file =foutcvs3, row.names = FALSE)
      ####   message(foutcvs3)
      }


      return(NULL)
      
  }
