% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode_approx.R
\name{mode_approx}
\alias{mode_approx}
\title{Gibbs sample mode}
\usage{
mode_approx(samples)
}
\arguments{
\item{samples}{[\code{numeric()}]\cr
Gibbs samples.}
}
\value{
The (approximated) mode.
}
\description{
This function approximates the Gibbs sample mode.
}
\examples{
samples <- oeli::rmixnorm(
  n = 1000, mean = matrix(c(-2, 2), ncol = 2),
  Sigma = matrix(c(1, 1), ncol = 2), proportions = c(0.7, 0.3)
)
hist(samples)
mean(samples) # expected: 0.7 * (-2) + 0.3 * 2 = -0.8
mode_approx(samples) # expected: -2
}
