% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Fit probit model to choice data}
\usage{
fit_model(
  data,
  scale = "Sigma_1,1 := 1",
  R = 1000,
  B = R/2,
  Q = 1,
  print_progress = getOption("RprobitB_progress", default = TRUE),
  prior = NULL,
  latent_classes = NULL,
  fixed_parameter = list(),
  save_beta_draws = FALSE
)
}
\arguments{
\item{data}{An object of class \code{RprobitB_data}.}

\item{scale}{[\code{character(1)}]\cr
A character which determines the utility scale. It is of the form
\verb{<parameter> := <value>}, where \verb{<parameter>} is either the name of a fixed
effect or \verb{Sigma_<j>,<j>} for the \verb{<j>}th diagonal element of \code{Sigma}, and
\verb{<value>} is the value of the fixed parameter.}

\item{R}{[\code{integer(1)}]\cr
The number of iterations of the Gibbs sampler.}

\item{B}{[\code{integer(1)}]\cr
The length of the burn-in period.}

\item{Q}{[\code{integer(1)}]\cr
The thinning factor for the Gibbs samples.}

\item{print_progress}{[\code{logical(1)}]\cr
Print the Gibbs sampler progress?}

\item{prior}{[\code{list}]\cr
A named list of parameters for the prior distributions. See the documentation
of \code{\link{check_prior}} for details about which parameters can be
specified.}

\item{latent_classes}{[\code{list()} | \code{NULL}]\cr
Optionally parameters specifying the number of latent classes and their
updating scheme. The values in brackets are the default.
\itemize{
\item \code{C} (\code{1}): The fixed number (greater or equal 1) of (initial) classes.
\item \code{wb_update} (\code{FALSE}): Set to \code{TRUE} for weight-based class updates.
\item \code{dp_update} (\code{FALSE}): Set to \code{TRUE} for Dirichlet process class updates.
\item \code{Cmax} (\code{10}): The maximum number of latent classes.
}

The following specifications are used for the weight-based updating scheme:
\itemize{
\item \code{buffer} (\code{50}): The number of iterations to wait before the next update.
\item \code{epsmin} (\code{0.01}): The threshold weight for removing a latent class.
\item \code{epsmax} (\code{0.7}): The threshold weight for splitting a latent class.
\item \code{deltamin} (\code{0.1}): The minimum mean distance before merging two classes.
\item \code{deltashift} (\code{0.5}): The scale for shifting the class means after a split.
}}

\item{fixed_parameter}{[\code{list}]\cr
A named list with fixed parameter values for \code{alpha},
\code{C}, \code{s}, \code{b}, \code{Omega}, \code{Sigma}, \code{Sigma_full},
\code{beta}, \code{z}, or \code{d} for the simulation.

See \href{https://loelschlaeger.de/RprobitB/articles/v01_model_definition.html}{the vignette on model definition}
for definitions of these variables.}

\item{save_beta_draws}{[\code{logical(1)}]\cr
Save draws for decider-specific coefficient vectors? Usually not recommended,
as it requires a lot of storage space.}
}
\value{
An object of class \code{RprobitB_fit}.
}
\description{
This function performs MCMC simulation for fitting different types of probit
models (binary, multivariate, mixed, latent class, ordered, ranked) to
discrete choice data.
}
\examples{
set.seed(1)
form <- choice ~ var | 0
data <- simulate_choices(form = form, N = 100, T = 10, J = 3, re = "var")
model <- fit_model(data = data, R = 1000)
summary(model)

}
\seealso{
\itemize{
\item \code{\link[=prepare_data]{prepare_data()}} and \code{\link[=simulate_choices]{simulate_choices()}} for building an
\code{RprobitB_data} object
\item \code{\link[=update]{update()}} for estimating nested models
\item \code{\link[=transform]{transform()}} for transforming a fitted model
}
}
