% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robin_estimate.R
\name{robin_wt}
\alias{robin_wt}
\title{Inverse Probability Weighting Based Inference}
\usage{
robin_wt(
  data,
  estimand = list(tx_colname = NULL, tx_to_compare = NULL),
  design = list(randomization_var_colnames = NULL, randomization_table = NULL),
  estimated_propensity = TRUE,
  outcome_model = list(formula = NULL, family = gaussian()),
  contrast_specs = list(contrast = "difference", contrast_jac = NULL),
  alpha = 0.05,
  ...
)
}
\arguments{
\item{data}{(\code{data.frame}) A data frame containing the dataset.}

\item{estimand}{(\code{list}) A list specifying the estimand, with two elements:
\itemize{
\item \code{tx_colname} (\code{character}): The column name of the treatment variable in \code{data}.
\item \code{tx_to_compare} (\verb{character vector}): A vector specifying exactly two treatment levels to compare.
}}

\item{design}{(\code{list}) A list specifying randomization information, with two elements:
\itemize{
\item \code{randomization_var_colnames} (\verb{character vector}): Column names of randomization variables in \code{data}.
\item \code{randomization_table} (\code{data.frame}, default: \code{NULL}): A data frame containing treatment assignment probabilities
for each level of the randomization variables. See \emph{Details}.
}}

\item{estimated_propensity}{(\code{logical}, default: \code{TRUE}) Whether to use estimated propensity scores.}

\item{outcome_model}{(\code{list}) A list specifying the outcome working model, with two elements:
\itemize{
\item \code{formula} (\code{formula}): The regression formula for the analysis.
\item \code{family} A description of the error distribution and link function for the model. Default: \code{gaussian()}.
}}

\item{contrast_specs}{(\code{list}) A list specifying the contrast function and its Jacobian:
\itemize{
\item \code{contrast} (\code{function} or \code{character}): A function to compute the treatment effect, or one of \code{"difference"},
\code{"risk_ratio"}, or \code{"odds_ratio"} for default contrasts.
\item \code{contrast_jac} (\code{function}, optional): A function to compute the Jacobian of the contrast function.
Ignored if using default contrasts.
}}

\item{alpha}{(\code{numeric}) The nominal significance level. Default: \code{0.05}.}

\item{...}{Additional arguments passed to \code{glm}.}
}
\value{
A treatment_effect object.
}
\description{
Provides robust inference via inverse probability weighting.
}
\details{
If \code{randomization_table} is provided, it must include columns corresponding to \code{randomization_var_colnames},
as well as treatment assignment probability columns named after the treatment levels in \code{tx_colname} from \code{data}.

If \code{family} is \code{MASS::negative.binomial(NA)}, the function will use \code{MASS::glm.nb} instead of \code{glm}.
}
\examples{
data_sim <- RobinCID::example
tx_colname <- "treatment"
treatment_levels <- unique(data_sim[[tx_colname]])
tx_to_compare <- c("trt.1", "trt.3")
randomization_var_colnames <- c("t", "subtype")
df <- data_sim[c("xb", "xc", tx_colname, randomization_var_colnames, "y")]
randomization_table <- unique(data_sim[c(randomization_var_colnames, treatment_levels)])
robin_wt(
  data = df,
  estimand = list(tx_colname = tx_colname,
                  tx_to_compare = tx_to_compare),
  design = list(randomization_var_colnames = randomization_var_colnames,
                randomization_table = randomization_table),
  estimated_propensity = FALSE,
  outcome_model = list(formula = y ~ 1,
                       family = gaussian())
)

}
