% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rmfrac.R
\docType{package}
\name{Rmfrac-package}
\alias{Rmfrac}
\alias{Rmfrac-package}
\title{Rmfrac: Simulation and analysis of multifractional processes}
\description{
A collection of tools for simulating, analysing and visualising multifractional processes
and time series. The package includes estimation techniques for the Hurst function,
Local Fractal Dimension and several other geometric statistics. It provides highly customisable
plotting functions for simulated realisations, user-provided time series and their statistics.
}
\section{Features}{

\itemize{
\item Simulation of Brownian motion, fractional Brownian motion, fractional Gaussian noise,
Brownian bridge and fractional Brownian bridge.
\item Simulation of Gaussian Haar-based multifractional process (GHBMP).
\item Estimation of Hurst function and Local Fractal Dimension.
\item Customisable plotting functions for GHBMP and user provided time series
with estimates of Hurst function and Local Fractal Dimension.
\item Estimation and visualisation of geometric statistics using realisations of stochastic processes
and time series. Clustering based on the Hurst function. Estimating sojourn measure, excursion area, etc.
\item An interactive Shiny application that provides options to explore and visualise
the core functionalities of the package through simulations and user-provided time series.
}
}

\seealso{
Useful links:
\itemize{
\item \url{https://github.com/Nemini-S/Rmfrac}
\item Report bugs at \url{https://github.com/Nemini-S/Rmfrac/issues}
}
}
\author{
\itemize{
\item Andriy Olenko \href{https://orcid.org/0000-0002-0917-7000}{ORCID} \href{mailto:a.olenko@latrobe.edu.au}{a.olenko@latrobe.edu.au}
\item Nemini Samarakoon \href{https://orcid.org/0009-0000-2107-1973}{ORCID} \href{mailto:neminisamarakoon95@gmail.com}{neminisamarakoon95@gmail.com}
}
}
