% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_team_styles.R
\name{get_team_styles}
\alias{get_team_styles}
\title{GET team styles}
\usage{
get_team_styles(team_id, page_size = 30, after = NULL, before = NULL)
}
\arguments{
\item{team_id}{string. The team's ID, with a list of its styles.}

\item{page_size}{number. Number of items in a paged list of results.
Defaults to 30.}

\item{after}{number. Cursor providing the id for which to begin component
retrieval. Exclusive with \code{before} parameter. The cursor value is a
tracked integer that is kept internally but has no Ids.}

\item{before}{number. The id before which to begin obtaining components is
shown by the cursor. Exclusive with after The cursor value is a tracked
integer that is kept internally but has no Ids.}
}
\value{
S3 object of class \code{rigma_get_team_styles}. Styles are
stored in the \code{meta} field.
}
\description{
Get a list of published styles in a team library that is
paginated.
}
\examples{
\dontshow{if (Sys.getenv("FIGMA_ACCESS_TOKEN") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
#navigate to team page and get id from url
get_team_styles(team_id = "1168610438838663284")
}
\dontshow{\}) # examplesIf}
}
