% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_comment_reactions.R
\name{delete_comment_reactions}
\alias{delete_comment_reactions}
\title{DELETE comment reactions}
\usage{
delete_comment_reactions(file_key, comment_id, emoji)
}
\arguments{
\item{file_key}{string. The key that a Figma file is referred by.}

\item{comment_id}{string. Comment id of comment to delete reaction from.}

\item{emoji}{string. The emoji type of reaction to delete as a string enum
:eyes:, :heart_eyes:, :heavy_plus_sign:, :+1:, :-1:, :joy: and :fire:}
}
\value{
S3 object of class \code{rigma_delete_comment_reactions}. Contains the
parsed JSON response with fields \code{error}, \code{status}, and \code{i18n}.
}
\description{
Removes a particular comment reaction. The only person with
the ability to delete a comment reaction is the original poster.
}
\examples{
\dontshow{if (Sys.getenv("FIGMA_ACCESS_TOKEN") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
# navigate to  file and get key from url
file_key <- "sFHgQh9dL6369o5wrZHmdR"
first_comment_id <- get_comments(file_key)$comments[[1]]$id
delete_comment_reactions(file_key, first_comment_id, ":eyes:")
}
\dontshow{\}) # examplesIf}
}
