% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getReactions.R
\name{getReactions}
\alias{getReactions}
\title{Extract total count of reactions to one or more Facebook posts}
\usage{
getReactions(post, token, verbose = TRUE, api = NULL)
}
\arguments{
\item{post}{A post ID, or a vector of post IDs}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{verbose}{logical, default is \code{TRUE}, which will print additional
information on the console.}

\item{api}{API version. e.g. "v2.8". \code{NULL} is the default.}
}
\description{
\code{getReactions} retrieves information from a single or multiple posts,
returning the total count of reactions of each type (like, love, haha,
wow, sad, angry).
}
\details{
The solution implemented here is based on this Stack Overflow response:
\url{http://stackoverflow.com/questions/36930414/how-can-i-get-facebook-graph-api-reaction-summary-count-separately}
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
## Getting information about Facebook's Facebook Page
load("fb_oauth")
fb_page <- getPage(page="facebook", token=fb_oauth)
## Getting reactions for most recent post
post <- getReactions(post=fb_page$id[1], token=fb_oauth)
}

}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{getPage}}, \code{\link{getPost}}
}

