% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Groupplot.fn.R
\name{Groupplot.fn}
\alias{Groupplot.fn}
\title{Function to plot the mean and error bar by group}
\usage{
Groupplot.fn(
  x,
  Average,
  GroupName,
  errorbar = NA,
  xRange = NA,
  yRange = NA,
  col = NA,
  pch = NA,
  Position = "topright",
  cex.legend = 0.75,
  xlab = "",
  ylab = "",
  main = ""
)
}
\arguments{
\item{x}{a vector for x axis.}

\item{Average}{Matrix for average in each group}

\item{GroupName}{a vector of names for each group}

\item{errorbar}{matrix for value of erorr bar}

\item{xRange}{range for the x-axis}

\item{yRange}{range for the y-axis}

\item{col}{a vector for the colors to indicate groups}

\item{pch}{a vector for points types to indicate groups}

\item{Position}{position for the legend}

\item{cex.legend}{cex for legend}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{main}{main title for the plot}
}
\value{
No value returned
}
\description{
function to plot the mean and error bar of sample entropy
or the MFDFA results by group
}
\examples{
data("HqData")
PP_Hq <- HqData
filenames <- row.names(PP_Hq)
q <- -10:10
ClassNames <- c(substr(filenames[1:19], start = 1, stop = 3),
                substr(filenames[20:38], start = 1, stop = 5))
Class <- unique(ClassNames)
for (i in 1:length(q)){
  Data <- GroupComparison.fn(PP_Hq[,i],ClassNames)
  Result_mean_vec <- Data[,"Mean"]
  Result_sd_vec <- Data[,"SE"]
  if( i == 1 ) {
    Result_mean_mat <- Result_mean_vec
    Result_sd_mat <- Result_sd_vec
  } else {
    Result_mean_mat <- rbind(Result_mean_mat, Result_mean_vec)
    Result_sd_mat <- rbind(Result_sd_mat, Result_sd_vec)
 }
}
Groupplot.fn (q[1:10],Result_mean_mat[1:10,],Class,errorbar = Result_sd_mat[1:10,],
              xRange = NA, yRange = NA, col = NA, pch = rep(16,4), Position = "topright",
              cex.legend = 1, xlab="q",ylab="Hurst exponent",main = "")
Groupplot.fn (q[11:21],Result_mean_mat[11:21,],Class,errorbar = Result_sd_mat[11:21,],
              xRange = NA, yRange = NA, col = NA, pch = rep(16,4), Position = "topright",
              cex.legend = 1, xlab="q",ylab="Hurst exponent",main = "")

}
\references{
Zhang T, Dong X, Chen C, Wang D, Zhang XD. RespirAnalyzer: an R package for continuous monitoring of respiratory signals.
}
