% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duane.R
\name{duane}
\alias{duane}
\title{Duane Analysis}
\usage{
duane(times, failures = NULL, conf.level = 0.95)
}
\arguments{
\item{times}{Either:
\itemize{
\item A numeric vector of exact failure times, or
\item A data frame containing two columns: \code{times} and \code{failures}. The \code{times}
column contains exact failure times, and the \code{failures} column
contains the number of failures at each corresponding time.
}}

\item{failures}{A numeric vector of the number of failures at each corresponding
time in \code{times}. Ignored if \code{times} is a data frame. Must be the same length as
\code{times} if both are vectors.
All values must be positive and finite.}

\item{conf.level}{Confidence level for the confidence bounds (default: \code{0.95}).
Must be between 0 and 1 (exclusive).}
}
\value{
A list of class \code{"duane"} containing:
\item{times}{The input exact failure times.}
\item{failures}{The input number of failures.}
\item{n_obs}{The number of observations (failures).}
\item{MTBF}{The cumulative mean time between failures.}
\item{model}{The fitted \code{lm} (linear model) object containing the regression results.}
\item{logLik}{The log-likelihood of the fitted model.}
\item{AIC}{Akaike Information Criterion (AIC).}
\item{BIC}{Bayesian Information Criterion (BIC).}
\item{conf.level}{The confidence level.}
\item{Cumulative_Time}{The cumulative operating times.}
\item{Cumulative_MTBF}{The cumulative mean time between failures.}
\item{Fitted_Values}{The fitted values on the MTBF scale.}
\item{Confidence_Bounds}{Matrix of fitted values and confidence bounds on the MTBF scale.}
\item{Residuals_Log}{Residuals on the log(MTBF) scale (from the regression).}
\item{Residuals_MTBF}{Residuals on the MTBF scale (observed - fitted).}
}
\description{
This function performs a Duane analysis (1962) \url{doi:10.1109/TA.1964.4319640}
on failure data by fitting a log-log linear regression of cumulative Mean Time
Between Failures (MTBF) versus cumulative time. The function accepts either
two numeric vectors (\code{times}, \code{failures}) or a data frame containing both.
}
\details{
The scaling relationship between the size of input data (numbers of observations)
and speed of algorithm execution is approximately linear (O(n)). The function is
efficient and can handle large data sets (e.g., thousands of observations) quickly.
The function uses base R functions and does not require any additional packages.
The function includes comprehensive input validation and error handling to ensure
robustness. The function is tested with a standard data set from a published paper
and includes unit tests to verify correctness and performance.
}
\examples{
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
fit1 <- duane(times, failures, conf.level = 0.90)
print(fit1)

df <- data.frame(times = times, failures = failures)
fit2 <- duane(df, conf.level = 0.95)
print(fit2)

}
\seealso{
Other Duane functions: 
\code{\link{plot.duane}()},
\code{\link{print.duane}()}
}
\concept{Duane functions}
