/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.curvefitting;

import gov.nih.ncats.ifx.qhts.curvefitting.FittingResult;
import gov.nih.ncats.ifx.qhts.curvefitting.service.CurveFittingServiceImpl;
import java.io.PrintStream;
import org.rosuda.JRI.RConsoleOutputStream;
import org.rosuda.JRI.Rengine;

public class CurveClassFit1 {
    private Rengine rEngine = new Rengine();

    public CurveClassFit1() {
        RConsoleOutputStream rConsoleOutputStream = new RConsoleOutputStream(this.rEngine, 0);
        PrintStream printStream = new PrintStream(rConsoleOutputStream);
        System.setOut(printStream);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.out.println("Usage: java CurveClassFit1 <conc> <resp> <classificationSD> <minYrange>");
            return;
        }
        CurveClassFit1 curveClassFit1 = new CurveClassFit1();
        Double[] doubleArray = CurveClassFit1.parseDoubleArray(stringArray[0]);
        Double[] doubleArray2 = CurveClassFit1.parseDoubleArray(stringArray[1]);
        Double d = Double.parseDouble(stringArray[2]);
        Double d2 = Double.parseDouble(stringArray[3]);
        curveClassFit1.performCurveFitting(doubleArray, doubleArray2, d, d2);
    }

    private void performCurveFitting(Double[] doubleArray, Double[] doubleArray2, Double d, Double d2) {
        CurveFittingServiceImpl curveFittingServiceImpl = new CurveFittingServiceImpl();
        FittingResult fittingResult = curveFittingServiceImpl.doFit(doubleArray, doubleArray2, d, d2);
        String string = fittingResult.toString();
        System.out.println(string);
    }

    private static Double[] parseDoubleArray(String string) {
        String[] stringArray = string.split("\\s+");
        Double[] doubleArray = new Double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            doubleArray[i] = Double.parseDouble(stringArray[i]);
        }
        return doubleArray;
    }
}

