% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_us_data.R
\name{plot_us_data}
\alias{plot_us_data}
\title{plot_us_data}
\usage{
plot_us_data(
  df = NULL,
  states_col = NULL,
  value_col = NULL,
  title = NULL,
  title_fontsz = 18,
  text_col = NULL,
  text_size = 3,
  text_color = "black",
  text_fontface = "plain",
  output_dir = tempdir(),
  delete_files = TRUE,
  vintage = 2020,
  general = FALSE,
  resol = "500k",
  na_rm = FALSE,
  scale_breaks = NULL,
  scale_values = NULL,
  scale_limits = NULL,
  scale_labels = waiver(),
  scale_colors = grDevices::heat.colors(8),
  scale_na_value = "gray50",
  own_scale = FALSE,
  sf_color = "black",
  sf_fill = "gray",
  sf_linewidth = 0.1,
  sf_alpha = 1,
  display_plot = TRUE,
  show_legend = TRUE,
  legend_pos = "right",
  legend_key_width = 0.5,
  legend_key_height = 0.7,
  legend_key_backgrd = "white"
)
}
\arguments{
\item{df}{The data frame with a column of full state names and a second variable column of their respective values.
The column name for the states must be "NAME". If 'df' is \code{NULL}, then only a sf object with the state geometries are returned.}

\item{states_col}{A required string (if 'df' is not \code{NULL}) that sets the column name from 'df' containing the state names of interest. These are
full state names, either capitalized or lower case.}

\item{value_col}{A required string (if 'df' is not \code{NULL}) that sets the column name from 'df' where values(discrete or continuous) are defined.
If the column has discrete values then it must be a factor.}

\item{title}{A string that sets the plot title.}

\item{title_fontsz}{A numeric that sets the title's font size. The default is 18.}

\item{text_col}{An optional string that sets the column name from 'df' for labeling each state polygon.}

\item{text_size}{A numeric value that sets the size of labeled state text.}

\item{text_color}{A string that sets the color of labeled state text.}

\item{text_fontface}{A string that sets the fontface of labeled state text.
Acceptable values: "plain", "bold", "italic", "bold.italic". The default is "plain".}

\item{output_dir}{A full directory path where the shapefile and its associated files will be downloaded.
The default is the directory defined by the value returned by \code{tempdir()}.}

\item{delete_files}{A logical which if \code{TRUE} will delete the shapefile and associated files in 'output_dir'.
The default is \code{TRUE}.}

\item{vintage}{A numeric that sets the vintage of interest. The default is 2020.}

\item{general}{A logical which if \code{TRUE} will download a less detailed, more generalized version of the state geometries.}

\item{resol}{If 'general' is \code{TRUE}, then the resolution to return. Acceptable values are strings
"500k", "5m", "20m".}

\item{na_rm}{A logical which if \code{TRUE}, missing observations are removed. If \code{FALSE}, the default,
missing observations are removed with a warning.}

\item{scale_breaks}{A required string/numeric vector that defines the scale breaks.}

\item{scale_values}{A string/numeric vector that defines the possible values. For factor values, this is required
and is a vector string of colors.}

\item{scale_limits}{A required string/numeric vector that defines the scale limits.}

\item{scale_labels}{An optional string vector that defines the scale labels. Vector must be the same length
as \code{scale_breaks}.}

\item{scale_colors}{Vector of colors to use for n-color gradient.}

\item{scale_na_value}{A string that sets the color for missing values.}

\item{own_scale}{A logical which if \code{TRUE}, then your own scaling may be appended to the plot without using the above
scale_* parameters.}

\item{sf_color}{A string that sets the polygon border line color.}

\item{sf_fill}{A string that sets the polygon area fill color.}

\item{sf_linewidth}{A numeric that sets the border line thickness.}

\item{sf_alpha}{A numeric that sets the alpha level attribute of the polygon fill.}

\item{display_plot}{A logical that if \code{TRUE} will display the plot. The default is \code{TRUE}.
If \code{FALSE}, then a ggplot2 object is returned}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{legend_pos}{A string that sets the legend position. Acceptable values are "right",
"top", "bottom".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}
}
\value{
A list of ggplot2 objects if 'display_plot' is \code{FALSE}. Included in the
list is the plot of all the states ("us_states") along with the original ggplot2
\code{ggplot2::geom_sf} plots of the lower 48 ("lower_48"), Alaska ("alaska"), Hawaii ("hawaii") and Puerto Rico ("puerto_rico").
}
\description{
This function produces a ggplot2 based choropleth map of a discrete/continuous variable across all/selected US states
including placement of Alaska, Hawaii, and Puerto Rico. The function accepts a data frame with a column of
state names and a column with their respective values.  If the data frame (parameter 'df') is submitted as \code{NULL} then only the simple
feature state geometries are returned for mapping. The function offers several options for
control/selection of state geographies and variable scaling.

This function depends extensively on \code{RcensusPkg::tiger_states_sf()} for obtaining state geometries, so many of
that function's parameters are repeated in this function. Also \code{RplotterPkg::create_sf_plot()} is called upon for
displaying the shapefile geometries, so this package should be installed.
}
\examples{
\dontrun{
library(sf)
library(grid)
library(ggplot2)
library(ggplotify)
library(data.table)
library(gtable)
library(httr2)
library(withr)
library(RplotterPkg)

# Plot just the states without joining data (the default case)
# Define a temporary output folder for the downloaded shapefiles
output_dir <- withr::local_tempdir()
if(!dir.exists(output_dir)){
  dir.create(output_dir)
}
us_without_data_plot <- RcensusPkg::plot_us_data(
 title = "A Default Mapping of US States",
 output_dir = output_dir,
 delete_files = FALSE
)

# Requires US Census Bureau API key
# Plot of US map with discrete 2020 presidential results
output_dir <- withr::local_tempdir()
if(!dir.exists(output_dir)){
  dir.create(output_dir)
}
a_plot <- RcensusPkg::plot_us_data(
  df = RcensusPkg::vote2020,
  title = "US Presidential Vote 2020",
  states_col = "State",
  value_col = "Party",
  output_dir = output_dir,
  delete_files = FALSE,
  scale_breaks = c("R","D"),
  scale_limits = c("R","D"),
  scale_values = c("red","blue"),
  scale_labels = c("Republican","Democrat"),
  sf_color = "white"
)
}
}
