% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glpk.R, R/helpers.R, R/lpsolve.R
\name{ata_glpk}
\alias{ata_glpk}
\alias{helpers}
\alias{ata_check_item_pool}
\alias{ata_item_set_groups}
\alias{ata_form_map}
\alias{ata_get_form_index}
\alias{ata_get_obj_coef}
\alias{ata_append}
\alias{ata_extract_items}
\alias{ata_results_to_model}
\alias{ata_results_to_dataframe}
\alias{ata_lpsolve}
\title{Helper functions for ATA}
\usage{
ata_glpk(x, time_limit, message, ...)

ata_check_item_pool(pool)

ata_item_set_groups(pool, opts)

ata_form_map(n_forms, opts)

ata_get_form_index(x, forms, collapse, internal_index)

ata_get_obj_coef(x, coef, compensate)

ata_append(x, mat, dir, rhs)

ata_extract_items(x)

ata_results_to_model(items)

ata_results_to_dataframe(items)

ata_lpsolve(x, time_limit, message, ...)
}
\arguments{
\item{x}{an ATA object}

\item{time_limit}{the time limit in seconds passed along to the solver}

\item{message}{\code{TRUE} to print messages from the solver}

\item{...}{additional control parameters for the solver}

\item{pool}{the item pool, a list of 3pl, gpcm, and grm items}

\item{opts}{the options, a list}

\item{n_forms}{the nubmer of forms to be assembled}

\item{forms}{form indices}

\item{collapse}{\code{TRUE} to collaspe forms into one form}

\item{internal_index}{\code{TRUE} to use internal form index}

\item{coef}{coefficients}

\item{compensate}{\code{TRUE} to combine coefficients}

\item{mat}{coefficient matrix}

\item{dir}{direction}

\item{rhs}{right-hand-side value}

\item{items}{the assembled items}
}
\description{
\code{ata_glpk} solves the the MIP model using GLPK

helper functions for ATA

\code{ata_check_item_pool} checks the input of the item pool

\code{ata_item_set_groups} creates grouping indices for item sets

\code{ata_form_map} creates a map of external and internal forms

\code{ata_get_form_index} finds the internal form indices for the form input

\code{ata_get_obj_coef} finds real coefficients for the coefficient input

\code{ata_append} appends constraints to the ATA model

\code{x} retrieves items from the result matrix

\code{ata_results_to_model} converts results from the 'by-form' format to the 'by-model' format

\code{ata_results_to_dataframe} converts results from the 'by-model' format to the 'data.frame' format

\code{ata_lpsolve} solves the the MIP model using lp_solve
}
\keyword{internal}
