% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_plus.R
\name{select_plus}
\alias{select_plus}
\title{Column selection with optional grouping variable}
\usage{
select_plus(.data, ..., var_group = NULL)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Columns to select (as in \code{dplyr::select()}).}

\item{var_group}{A character string or vector of column names to additionally include,
typically one or more grouping variables. Can be \code{NULL}.}
}
\value{
A data frame with the selected columns, including \code{var_group} if specified.
}
\description{
This function extends \code{dplyr::select()} by allowing the dynamic addition of one or more grouping
variables (\code{var_group}) to the selection.
}
\details{
It is especially useful when switching between an ungrouped analysis (e.g., all observations together)
and a grouped analysis (e.g., stratified or including interaction terms), without rewriting code.

For instance, this allows you to write a single analysis command for both the RDD (Rapport de Démarrage des Données)
and the final report, simply by changing the \code{.qmd} file, without modifying the core analysis code.
}
\examples{
library(dplyr)
df <- tibble(x = 1:3, y = 4:6, z = 7:9)

# Simple selection
select_plus(df, x, y)

# Selection with grouping variable
select_plus(df, x, var_group = "z")
}
