% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Raquifer_package.R
\name{aquifer_param}
\alias{aquifer_param}
\title{A list object for aquifer prameters}
\usage{
aquifer_param(
  input_unit = NULL,
  output_unit = NULL,
  model = NULL,
  flow_type = NULL,
  water_drive = NULL,
  phi = NULL,
  perm_h = NULL,
  perm_v = NULL,
  h_a = NULL,
  r_a = NULL,
  r_R = NULL,
  w_a = NULL,
  l_a = NULL,
  tetha = NULL,
  mu_water = NULL,
  c_water = NULL,
  c_rock = NULL,
  pressure = NULL
)
}
\arguments{
\item{input_unit}{a unit system for parameters, a character string either 'SI' or 'Field'}

\item{output_unit}{a unit system for properties, a character string either 'SI' or 'Field'}

\item{model}{state of flow in the aquifer, a character string either 'uss' for the un-steady state flow or 'pss' for the pseudo-steady state flow}

\item{flow_type}{a character string either 'radial' or 'linear'}

\item{water_drive}{a character string either 'edge' or 'bottom'}

\item{phi}{aquifer porosity, a numeric fraction}

\item{perm_h}{aquifer horizontal permeability in 'md' in both 'SI' and 'Field' input unit systems. A NULL value must be used for the combination of 'uss', 'linear', and 'bottom' flow}

\item{perm_v}{aquifer vertical permeability in 'md' in both 'SI' and 'Field' input unit systems. A NULL value must be used for the combination of 'uss', 'linear', 'edge' flow. A NULL value must be used for the combination of 'uss', 'radial', 'edge' flow. A NULL value must be used for the combination of 'pss', 'radial', 'edge' flow.}

\item{h_a}{aquifer height in 'm' or 'ft' in 'SI' and 'Field' input unit systems, respectively.}

\item{r_a}{aquifer radius in 'm' or 'ft' in 'SI' and 'Field' input unit systems, respectively. A NULL value must be used for the combination of 'uss', 'linear', 'edge' flow. A NULL value must be used for the combination of 'uss', 'linear', 'bottom' flow.}

\item{r_R}{reservoir radius in 'm' or 'ft' in 'SI' and 'Field' input unit systems, respectively. A NULL value must be used for the combination of 'uss', 'linear', 'edge' flow. A NULL value must be used for the combination of 'uss', 'linear', 'bottom' flow.}

\item{w_a}{aquifer width in 'm' or 'ft' in 'SI' and 'Field' input unit systems, respectively. A NULL value must be used for the combination of 'uss', 'radial', 'edge' flow. A NULL value must be used for the combination of 'uss', 'radial', 'bottom' flow. A NULL value must be used for the combination of 'pss', 'radial', 'edge' flow.}

\item{l_a}{aquifer length in 'm' or 'ft' in 'SI' and 'Field' input unit systems, respectively. A NULL value must be used for the combination of 'uss', 'radial', 'edge' flow. A NULL value must be used for the combination of 'uss', 'radial', 'bottom' flow. A NULL value must be used for the combination of 'pss', 'radial', 'edge' flow.}

\item{tetha}{fraction of reservoir encircled by the aquifer, reported in "degrees" in both 'SI' and 'Field' input unit systems. A NULL value must be used for the combination of 'uss', 'radial', 'bottom' flow. A NULL value must be used for the combination of 'uss', 'linear', 'edge' flow. A NULL value must be used for the combination of 'uss', 'linear', 'bottom' flow.}

\item{mu_water}{water viscosity in 'mPa.s' or 'cp' in 'SI' and 'Field' input unit systems, respectively}

\item{c_water}{water compressibility in '1/kPa' or '1/psi' in 'SI' and 'Field' input unit systems, respectively}

\item{c_rock}{rock compressibility in '1/kPa' or '1/psi' in 'SI' and 'Field' input unit systems, respectively}

\item{pressure}{a numeric vector of pressure data at the boundary of reservoir/aquifer. Must have the same length as the 'aquifer_time()' object}
}
\value{
a list of class 'aquifer' with all the required parameters for the aquifer_predict() S3 methods
}
\description{
Create an object of class 'aquifer'
}
\examples{

aquifer_param_01 <- aquifer_param(input_unit = "Field", output_unit = "Field",
model = "uss", flow_type = "radial", water_drive = "edge", phi = 0.2, perm_h = 100,
h_a = 47, r_a = 2e4, r_R = 2e3, tetha = 360, mu_water = 0.34, c_water = 4e-6,
c_rock = 3e-6, pressure = c(3456, 3425, 3387, 3350, 3312))

aquifer_param_01

aquifer_param_02 <- aquifer_param(input_unit = "SI", output_unit = "SI",
model = "uss", flow_type = "radial", water_drive = "bottom", phi = 0.2, perm_h = 100,
perm_v = 25, h_a = 25, r_a = 6000, r_R = 600, mu_water = 0.34, c_water = 6e-7,
c_rock = 4.5e-7, pressure = c(3456, 3425, 3387, 3350, 3312) * 6.895)

aquifer_param_02

aquifer_param_03 <- aquifer_param(input_unit = "Field", output_unit = "Field",
model = "pss", flow_type = "radial", water_drive = "edge", phi = 0.2, perm_h = 100,
h_a = 47, r_a = 2e4, r_R = 2e3, tetha = 360, mu_water = 0.34, c_water = 4e-6,
c_rock = 3e-6, pressure = c(3456, 3425, 3387, 3350, 3312))

aquifer_param_03

aquifer_param_04 <- aquifer_param(input_unit = "Field", output_unit = "Field",
model = "uss", flow_type = "linear", water_drive = "edge", phi = 0.2, perm_h = 100,
h_a = 47, w_a = 30000, l_a = 10000, mu_water = 0.34, c_water = 4e-6,
c_rock = 3e-6, pressure = c(3456, 3425, 3387, 3350, 3312))

aquifer_param_04

aquifer_param_05 <- aquifer_param(input_unit = "Field", output_unit = "Field",
model = "uss", flow_type = "linear", water_drive = "bottom", phi = 0.2, perm_v = 10,
h_a = 47, w_a = 4000, l_a = 4000, mu_water = 0.34, c_water = 4e-6,
c_rock = 3e-6, pressure = c(3456, 3425, 3387, 3350, 3312))

aquifer_param_05
}
