% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_functions.R
\name{lowerBound}
\alias{lowerBound}
\title{Lower bound value}
\usage{
lowerBound(umat, partial.ranking)
}
\arguments{
\item{umat}{a \code{matrix}, which is either the output of \code{\link{evaluationMatrix}},
or a subset of the output of \code{\link{evaluationMatrix}}.}

\item{partial.ranking}{a vector of rank positions
for each \code{Item} in \code{umat} that is ranked so far;
partial rankings may contain some - or all - \code{NA}
values.}
}
\value{
A numeric value  for the lower bound of a \code{partial.ranking}
}
\description{
This function is called by \code{\link{RankAggregator}}::\code{\link{consensusRanking}}.
The lower bound is the absolute lowest value a complete candidate ranking
could attain. Note, this value is not always achievable, so may differ
from the value returned by \code{\link{upperBound}}.\preformatted{     For each pair of \code{Item}s, there are three possible calculations, depending
     on whether both \code{Item}s are in the \code{partial.ranking}, one is in
     and the other is out the \code{partial.ranking}, or both are not in
     the \code{partial.ranking}.
}
}
