% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data100x15.R
\docType{data}
\name{data100x15}
\alias{data100x15}
\title{Simulated 100  \eqn{\times}{ X }  15 Data}
\format{
A data frame with 100 rows and 16 columns:
\describe{
\item{Object}{object name}
\item{Ranking 1}{ranking on the first attribute}
\item{Ranking 2}{ranking on the second attribute}
\item{Ranking 3}{ranking on the third attribute}
\item{Ranking 4}{ranking on the fourth attribute}
\item{Ranking 5}{ranking on the fifth attribute}
\item{Ranking 6}{ranking on the sixth attribute}
\item{Ranking 7}{ranking on the seventh attribute}
\item{Ranking 8}{ranking on the eigth attribute}
\item{Ranking 9}{ranking on the ninth attribute}
\item{Ranking 10}{ranking on the tenth attribute}
\item{Ranking 11}{ranking on the eleventh attribute}
\item{Ranking 12}{ranking on the twelfth attribute}
\item{Ranking 13}{ranking on the thirteenth attribute}
\item{Ranking 14}{ranking on the fourteenth attribute}
\item{Ranking 15}{ranking on the fifteenth attribute}
}
}
\source{
Badal, P. S., & Das, A. (2018). Efficient algorithms using subiterative
convergence for Kemeny ranking problem. Computers & Operations Research, 98, 198-210.
\doi{10.1016/j.cor.2018.06.007}
}
\usage{
data(data100x15)
}
\description{
Data of 100 objects and 15 attributes, in which the first column contains the object
names and each subsequent column is a complete ranking of the 100 objects. The
included 50  \eqn{\times}{ X }  15 and 400  \eqn{\times}{ X }  15 datasets were generated from this dataset (see
\code{\link{data50x15}} and \code{\link{data400x15}}).
}
\examples{
data(data100x15)
input_rkgs <- t(as.matrix(data100x15[, -1]))
obj_names <- data100x15[,1]

# Determine the mean seed ranking
mean_seed(input_rkgs)
}
\keyword{datasets}
