% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life_elas.R
\name{life_elas}
\alias{life_elas}
\title{Calculate Keyfitz's entropy from a trajectory of age-specific survivorship}
\usage{
life_elas(lx, trapeze = FALSE, ...)
}
\arguments{
\item{lx}{Either a survivorship trajectory (a vector of
monotonically-declining values in the interval [0,1]), or submatrix U from
a matrix population model.}

\item{trapeze}{A logical argument indicating whether the composite trapezoid
approximation should be used for approximating the definite integral.}

\item{...}{Additional variables passed to `mpm_to_lx` if data are supplied as
a matrix. This could include the `start` argument to select a starting
stage.}
}
\value{
Keyfitz's life table entropy.
}
\description{
Calculate Keyfitz's entropy from a vector of age-specific survivorship
(\code{lx}), or from the U submatrix of a matrix population model.
}
\section{Warning}{

Note that this function, which was formerly called `entropy_k` may produce
unexpected results if used on partial survivorship trajectories. In addition,
it is sensitive to the length of the survivorship vector. We direct users to
the function `\code{\link{shape_surv}}` which is relatively robust to these
issues.

Furthermore, de Vries et al. 2023 have shown that the way this function
calculates entropy is problematic for other reasons. We recommend to use
`\code{\link{entropy_k_age}}` or ``\code{\link{entropy_k_stage}}` as
alternatives, See de Vries et al. 2023 for details.
}

\examples{
data(mpm1)

# derive lx trajectory, starting from stage 2
lx <- mpm_to_lx(mpm1$matU, start = 2)

# calculate Keyfitz' entropy
life_elas(lx)

# use trapezoid approximation for definite integral
life_elas(lx, trapeze = TRUE)

# calculate directly from the matrix
life_elas(mpm1$matU)

}
\references{
Keyfitz, N. 1977. Applied Mathematical Demography. New York:
  Wiley.

  Demetrius, L., & Gundlach, V. M. 2014. Directionality theory and
  the entropic principle of natural selection. Entropy 16: 5428-5522.

  de Vries, C., Bernard, C., & Salguero-Gómez, R. 2023. Discretising
  Keyfitz' entropy for studies of actuarial senescence and comparative
  demography. Methods in Ecology and Evolution, 14, 1312–1319.
  <doi:10.1111/2041-210X.14083>
}
\seealso{
Other life history traits: 
\code{\link{entropy_d}()},
\code{\link{entropy_k}()},
\code{\link{entropy_k_age}()},
\code{\link{entropy_k_stage}()},
\code{\link{gen_time}()},
\code{\link{life_expect_mean}()},
\code{\link{longevity}()},
\code{\link{net_repro_rate}()},
\code{\link{repro_maturity}},
\code{\link{shape_rep}()},
\code{\link{shape_surv}()}
}
\author{
Owen R. Jones <jones@biology.sdu.dk>

Roberto Salguero-Gomez <rob.salguero@zoo.ox.ac.uk>
}
\concept{life history traits}
