% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ZigZagLogistic}
\alias{ZigZagLogistic}
\title{ZigZagLogistic}
\usage{
ZigZagLogistic(dataX, dataY, n_iter = -1L, finalTime = -1,
  x0 = numeric(0), v0 = numeric(0), cv = FALSE)
}
\arguments{
\item{dataX}{Design matrix containing observations of the independent variables x. The i-th row represents the i-th observation with components x_{i,1}, ..., x_{i,d}.}

\item{dataY}{Vector of length n containing {0, 1}-valued observations of the dependent variable y.}

\item{n_iter}{Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.}

\item{finalTime}{If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})}

\item{x0}{starting point (optional, if not specified taken to be the origin)}

\item{v0}{starting direction (optional, if not specified taken to be +1 in every component)}

\item{cv}{optional boolean to indicate the use of subsampling with control variates}
}
\value{
Returns a list with the following objects:

\code{Times}: Vector of switching times

\code{Positions}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.

\code{Velocities}: Matrix whose columns are velocities just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
}
\description{
Applies the Zig-Zag Sampler to logistic regression, as detailed in Bierkens, Fearnhead, Roberts, The Zig-Zag Process and Super-Efficient Sampling for Bayesian Analysis of Big Data, 2019.
}
\examples{
require("RZigZag")

generate.logistic.data <- function(beta, n.obs) {
  dim <- length(beta)
  dataX <- cbind(rep(1.0,n.obs), matrix(rnorm((dim -1) * n.obs), ncol = dim -1));
  vals <- dataX \%*\% as.vector(beta)
    generateY <- function(p) { rbinom(1, 1, p)}
  dataY <- sapply(1/(1 + exp(-vals)), generateY)
    return(list(dataX = dataX, dataY = dataY))
}

beta <- c(1,2)
data <- generate.logistic.data(beta, 1000)
result <- ZigZagLogistic(data$dataX, data$dataY, 1000)
plot(result$Positions[1,], result$Positions[2,],type='l',asp=1)
}
