% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_not}
\alias{rx_not}
\title{Ensure that the parameter does not follow.}
\usage{
rx_not(.data = NULL, value)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{value}{Value to ensure absence of}
}
\description{
This expression uses a \emph{negative lookahead} to ensure the
value given does not follow the previous verbal expression,
\code{perl = TRUE} is required. For example, if you were to look for the
letter \emph{q} but not the letter \emph{u} you might translate this to,
"find the letter q everytime the letter u does \emph{not} come after it".
}
\examples{
rx_not(value = "FEB-28")

# construct expression
x <- rx() \%>\%
  rx_start_of_line() \%>\%
  rx_find('FEB-29') \%>\%
  rx_not("FEB-28")

# create a string
string <- c("FEB-29-2017", "FEB-28-2017")

# extract matches, perl = TRUE is required for negative lookahead
regmatches(string, regexpr(x, string, perl = TRUE))

# another example
rx() \%>\%
  rx_find("q") \%>\%
  rx_not("u") \%>\%
  grepl(x = c("qu", "qa", "qq", "q", "q u"), perl = TRUE)

}
\references{
Negative lookahead: \url{https://www.regular-expressions.info/lookaround.html}
}
